<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e($aboutUs->seo_keywords ?? ''); ?>" />
    <meta name="description" content="<?php echo e($aboutUs->seo_description ?? ''); ?>" />
    <meta property="og:title" content="<?php echo e($aboutUs->seo_title ?? ''); ?>" />
    <meta property="og:description" content="<?php echo e($aboutUs->seo_description ?? ''); ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:locale" content="fa_IR" />
    <meta property="og:image" content="<?php echo e(asset($setting->header_logo ?? '')); ?>" />
    <meta name="twitter:title" content="<?php echo e($aboutUs->seo_title ?? ''); ?>"/>
    <meta name="twitter:description" content="<?php echo e($aboutUs->seo_description ?? ''); ?>" />
    <meta name="twitter:image" content="<?php echo e(asset($setting->header_logo ?? '')); ?>" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="@parhoonsazeh" />
    <meta name="twitter:creator" content="@parhoonsazeh" />
    <meta property="og:url" content="<?php echo e(route('front.aboutUsPage.index')); ?>">
    <link rel="canonical" href="<?php echo e(route('front.aboutUsPage.index')); ?>" />
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="theme-color" content="#252525">
    <link rel="shortcut icon" href="<?php echo e(asset($setting->header_logo ?? '')); ?>" type=image/x-icon>
    <meta name="robots" content="index,follow" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', __('labels.about_us')); ?>
<?php $__env->startSection('head'); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('style'); ?>
    <style>
        .meet-the-owners-left {
            left: auto !important;
            right: 0% !important;
        }
        .meet-the-owners-right {
            padding: 90px 245px 90px 55px !important;
        }
        .shop-local-container{
            direction: rtl;
        }

        @media only screen and (max-width: 600px) {
            .meet-the-owners-right {
                padding: 10px !important;
            }
        }
        /*.customer {
            padding-bottom: 7rem;
        }*/
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('FrontTmpAssets/css/about.css')); ?>"/>

    <section class="container-fluid py-3"></section>
    <section class=" customer">
        <div class="col-12 wow fadeInUp ">
            <?php if($aboutUs->slideshow_status): ?>
                <div class="hero-section about-hero"
                     style="background-image: -webkit-gradient(linear, left bottom, left top, from(#222), to(rgba(34, 34, 34, 0))), url('<?php echo e(asset($aboutUs->slideshow_image ?? '')); ?>');">
                    <div class="p_container">
                        <div class="hero-wrapper">
                            <h1 class="hero-heading anout-hero-heading">
                                <?php echo e($aboutUs->slideshow_title ?? ''); ?>

                            </h1>
                            <p class="hero-paragraph mb-3 mb-md-5">
                                <?php echo e($aboutUs->slideshow_text ?? ''); ?>

                            </p>
                            <div class="hero-button-wrapper">
                                <?php if(!empty($aboutUs->slideshow_button_title)): ?>
                                    <a href="<?php echo e($aboutUs->slideshow_button_link ?? ''); ?>" class="p_btn light outline w-button">
                                        <?php echo e($aboutUs->slideshow_button_title ?? ''); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="content-section why-acme-sections wf-section">
                <div class="p_container">
                    <div class="about-top-block">
                        <div class="why-acme-block">
                            <?php echo $aboutUs->body ?? ''; ?>

                        </div>
                    </div>
                </div>
            </div>

            <?php if(!empty($aboutUs->body_items)): ?>
                <?php if(!empty(json_decode($aboutUs->body_items))): ?>
                    <div class="content-section wf-section">
                        <div class="p_container">
                            <div class="about-columns-wrapper">
                                <?php
                                    $bodyItems = json_decode($aboutUs->body_items);
                                    $bodyItems = collect($bodyItems)->sortBy('sort_order');
                                ?>
                                <?php if(!empty($bodyItems)): ?>
                                    <?php if(count($bodyItems)): ?>
                                        <?php $__currentLoopData = $bodyItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bodyItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="about-column">
                                                <img src="<?php echo e(asset($bodyItem->image ?? '')); ?>" alt="Warranty Icon"
                                                     class="p_image">
                                                <h3>
                                                    <?php echo e($bodyItem->title ?? ''); ?>

                                                </h3>
                                                <p>
                                                    <?php echo e($bodyItem->text ?? ''); ?>

                                                </p>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php if($aboutUs->bottom_body_status == true): ?>
                <div class="content-section wf-section">
                    <div class="p_container shop-local-container">
                        <div class="content-wrapper">
                            <div class="meet-the-owners-wrapper">
                                <div class="meet-the-owners-left"
                                     style="background-image: url('<?php echo e(asset($aboutUs->bottom_body_image ?? '')); ?>');"></div>
                                <div class="meet-the-owners-right">
                                    <div class="owners-rich-text w-richtext">
                                        <h2>
                                            <?php echo e($aboutUs->bottom_body_title ?? ''); ?>

                                        </h2>
                                        <p>
                                        <?php if(!empty($aboutUs->bottom_body_text)): ?>
                                            <?php $__currentLoopData = explode("\n", $aboutUs->bottom_body_text ?? ''); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bottom_body_textLine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p>
                                                    <?php echo e($bottom_body_textLine ?? ''); ?>

                                                </p><br/>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                                </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(!empty($aboutUs->persons)): ?>
                <?php if(!empty(json_decode($aboutUs->persons))): ?>
                    <div class="content-section wf-section">
                        <div class="p_container">
                            <div class="owner-bios-wrapper">
                                <?php
                                    $persons = json_decode($aboutUs->persons);
                                    $persons = collect($persons)->sortBy('sort_order');
                                ?>
                                <?php if(!empty($persons)): ?>
                                    <?php if(count($persons)): ?>
                                        <?php $__currentLoopData = $persons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="owner-bio">
                                                <div class="owner-avatar-wrapper">
                                                    <img src="<?php echo e(asset($person->image ?? '')); ?>" alt="<?php echo e($person->title ?? ''); ?>">
                                                </div>
                                                <h3>
                                                    <?php echo e($person->title ?? ''); ?>

                                                </h3>
                                                <p class="owner-bio-paragraph">
                                                    <?php echo e($person->text ?? ''); ?>

                                                </p>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            <?php if($aboutUs->bottom_slideshow_status == true): ?>
                <div class="hero-section contact-hero wf-section"
                     style="    background-image: -webkit-gradient(linear, left bottom, left top, from(#222), to(rgba(34, 34, 34, 0))), url('<?php echo e(asset($aboutUs->bottom_slideshow_image ?? '')); ?>');">
                    <div class="p_container">
                        <div class="hero-wrapper">
                            <h1 class="hero-heading anout-hero-heading">
                                <?php echo e($aboutUs->bottom_slideshow_title ?? ''); ?>

                            </h1>
                            <p class="hero-paragraph mb-3 mb-md-5">
                                <?php echo e($aboutUs->bottom_slideshow_text ?? ''); ?>

                            </p>
                            <div class="hero-button-wrapper">
                                <?php if(!empty($aboutUs->bottom_slideshow_button_title)): ?>
                                    <a href="<?php echo e($aboutUs->bottom_slideshow_button_link ?? ''); ?>"
                                       class="p_btn light outline w-button">
                                        <?php echo e($aboutUs->bottom_slideshow_button_title ?? ''); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>

    </section>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script_whole'); ?> <?php $__env->stopSection(); ?>

<?php echo $__env->make('Front.Layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nonegar7/public_html/propfa.nonegar11.ir/LaravelCore/resources/views/Front/AboutUsPage/index.blade.php ENDPATH**/ ?>