<?php $__env->startSection('meta'); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('title', 'وبلاگ'); ?>
<?php $__env->startSection('head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/blog.css')); ?>"/>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
    <div class="pb-3 pt-2">
        <header class="py-3 bg-light border-bottom mb-4">
            <div class="container">
                <div class="text-center my-5">
                    <h1 class="fw-bolder">
                        <?php echo e($title ?? 'وبلاگ'); ?>

                    </h1>
                    <p class="lead mb-0">
                        <?php echo e($description ?? ''); ?>

                    </p>
                </div>
            </div>
        </header>
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <?php if($featured): ?>
                        <div class="card mb-4">
                            <?php if($featured->image): ?>
                                <a href="<?php echo e($featured->path()); ?>">
                                    <img class="card-img-top"
                                         src="<?php echo e(asset($featured->image ?? '' )); ?>"
                                         alt="<?php echo e($featured->title); ?>" />
                                </a>
                            <?php endif; ?>
                            <div class="card-body">
                                <div class="small text-muted">
                                    <?php echo e(convert_to_jalali($featured->created_at->toDateString())); ?>

                                </div>
                                <h2 class="card-title"><?php echo e($featured->title); ?></h2>
                                <p class="card-text"><?php echo e($featured->description); ?></p>
                                <a class="btn btn-primary" href="<?php echo e($featured->path()); ?>">
                                    ادامه مقاله
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(count($articles)): ?>
                        <div class="row">
                            <?php $__currentLoopData = $articles->chunk(ceil(count($articles)/2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunkedArticle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-6">
                                    <?php $__currentLoopData = $chunkedArticle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-4">
                                            <?php if($article->image): ?>
                                                <a href="<?php echo e($article->path()); ?>">
                                                    <img class="card-img-top"
                                                         src="<?php echo e(asset($article->image ?? '')); ?>"
                                                         alt="<?php echo e($article->title); ?>" />
                                                </a>
                                            <?php endif; ?>
                                            <div class="card-body">
                                                <div class="small text-muted">
<?php echo e(convert_to_jalali($article->created_at->toDateString())); ?>

                                                </div>
                                                <h2 class="card-title h4"><?php echo e($article->title); ?></h2>
                                                <p class="card-text"><?php echo e($article->description); ?></p>
<a class="btn btn-primary" href="<?php echo e($article->path()); ?>">ادامه مقاله</a>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                    <?php if(!$featured && !count($articles)): ?>
                        <div class="alert alert-danger" role="alert">
                            <span class="fa fa-ban"></span>
                            هیچ مقاله‌ای یافت نشد
                        </div>
                    <?php endif; ?>
                    <?php echo $articles->appends($_GET)->links(); ?>

                </div>
                <?php echo $__env->make('Front.Blog.sidebar', [ 'action' => '', 'show_widgets' => false ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script_whole'); ?> <?php $__env->stopSection(); ?>

<?php echo $__env->make('Front.Layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nonegar7/public_html/propfa.nonegar11.ir/LaravelCore/resources/views/Front/Blog/index.blade.php ENDPATH**/ ?>