<?php $__env->startSection('meta'); ?>
    <meta name="keywords" content="<?php echo e($contactUs->seo_keywords ?? ''); ?>" />
    <meta name="description" content="<?php echo e($contactUs->seo_description ?? ''); ?>" />
    <meta property="og:title" content="<?php echo e($contactUs->seo_title ?? ''); ?>" />
    <meta property="og:description" content="<?php echo e($contactUs->seo_description ?? ''); ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:locale" content="fa_IR" />
    <meta property="og:image" content="<?php echo e(asset($setting->header_logo ?? '')); ?>" />
    <meta name="twitter:title" content="<?php echo e($contactUs->seo_title ?? ''); ?>"/>
    <meta name="twitter:description" content="<?php echo e($contactUs->seo_description ?? ''); ?>" />
    <meta name="twitter:image" content="<?php echo e(asset($setting->header_logo ?? '')); ?>" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="@parhoonsazeh" />
    <meta name="twitter:creator" content="@parhoonsazeh" />
    <meta property="og:url" content="<?php echo e(route('front.contactUsPage.index')); ?>">
    <link rel="canonical" href="<?php echo e(route('front.contactUsPage.index')); ?>" />
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="theme-color" content="#252525">
    <link rel="shortcut icon" href="<?php echo e(asset($setting->header_logo ?? '')); ?>" type=image/x-icon>
    <meta name="robots" content="index,follow" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('title', __('labels.contact_us')); ?>
<?php $__env->startSection('head'); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('style'); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('FrontTmpAssets/css/contact.css')); ?>"/>


    <section class="container-fluid py-3"></section>
    <section class="customer">
        <div class="col-12 wow fadeInUp ">

            <?php if($contactUs->slideshow_status): ?>
                <div class="contact-hero-section">
                    <div class="contact-hero-bg-wrapper">
                        <div class="p_container contact">
                            <h1 class="p_heading">
                                <?php echo e($contactUs->slideshow_title ?? ''); ?>

                            </h1>
                            <div class="contact-block-wrapper">
                                <?php if(!empty($contactUs->slideshow_items)): ?>
                                    <?php if(!empty(json_decode($contactUs->slideshow_items))): ?>
                                        <?php
                                            $items = json_decode($contactUs->slideshow_items);
                                            $items = collect($items)->sortBy('sort_order');
                                        ?>
                                        <?php if(!empty($items)): ?>
                                            <?php if(count($items)): ?>
                                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="contact-block">
                                                        <img src="<?php echo e($item->image ?? ''); ?>" alt="" class="contact-icon">
                                                        <h2>
                                                            <?php echo e($item->title ?? ''); ?>

                                                        </h2>
                                                        <p>
                                                            <?php echo e($item->text ?? ''); ?>

                                                        </p>
                                                        <a href="<?php echo e($item->button_link ?? ''); ?>" class="p_btn w-button">
                                                            <?php echo e($item->button_title ?? ''); ?>

                                                        </a>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="contact-image-div" style="background-image: linear-gradient(90deg, #222, rgba(34, 34, 34, 0.18) 76%), url('https://bahnid.nonegar3.ir/FrontTmpAssets/images/ctu.jpg')"></div>
                    </div>
                </div>
            <?php endif; ?>

            <div id="contact" class="content-section ">
                <div class="p_container">
                    <div class="contact-wrapper">
                        <div class="contact-left">
                            <?php echo $contactUs->body_one ?? ''; ?>

                        </div>
                        <div class="contact-right">

                            <?php echo $contactUs->body_two ?? ''; ?>


                            <div class="w-form">
                                <form action="<?php echo e(route('front.contactUsPage.sendMessage')); ?>" method="post" id="email-form" name="email-form" data-name="Email Form" class="email-form">
                                    <?php echo e(csrf_field()); ?>


                                    <label for="name">
                                        <?php echo e(__('labels.name')); ?>

                                    </label>
                                    <input type="text" class=" w-input" maxlength="256" name="name" data-name="Name" id="name" required>

                                    <label for="email">
                                        <?php echo e(__('labels.email')); ?>

                                    </label>
                                    <input type="email" class=" w-input" maxlength="256" name="email" data-name="Email" id="email" required="">

                                    <label for="Message">
                                        <?php echo e(__('labels.message')); ?>

                                    </label>
                                    <textarea maxlength="5000" id="Message" name="message" data-name="Message" class=" w-input" required></textarea>
                                    <input type="submit" value="<?php echo e(__('labels.send')); ?>" data-wait="Please wait..." class="p_btn w-button align-self-baseline">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script_whole'); ?>
    <script>
        $("#email-form").on("submit", function(e){
            e.preventDefault();

            var thisForm = $(this);

            fnctn_loadWaiter("<?php echo e(__('labels.ajax_sending')); ?>");
            var data = $(this).serialize();
            var url = $(this).attr('action');
            var type = $(this).attr('method');

            $.ajax({
                data:data,
                type:type,
                url:url,
                success:function(){
                    fnctn_unloadWaiter();

                    Swal.fire({
                        icon: 'success',
                        title: '',
                        text: "<?php echo e(__('labels.stored')); ?>",
                        confirmButtonText: "<?php echo e(__('labels.alert_confirm_button')); ?>"
                    });

                    thisForm.find('input').prop('disabled', true);
                    thisForm.find('textarea').prop('disabled', true);
                    thisForm.find('button').prop('disabled', true);
                },
                error:function(err){
                    fnctn_unloadWaiter();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Front.Layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\propfa\LaravelCore\resources\views/Front/ContactUsPage/index.blade.php ENDPATH**/ ?>