<?php

use Illuminate\Support\Facades\Route;

/*
 * Admin
 */
Route::group(['prefix'=>'admin', 'as'=>'admin.', 'namespace'=>'Admin'], function() {
    Route::get('/', ['uses' => 'AdminController@admin_panel', 'as' => 'panel']);
    /*REGISTER and LOGIN*/
    Route::group(['prefix'=>'auth', 'namespace'=>'Auth'], function(){
        Route::get('/login', ['uses' => 'LoginController@showLoginForm', 'as' => 'login']);
        Route::post('/login', ['uses' => 'LoginController@login', 'as' => 'login']);
        Route::get('/logout', ['as' => 'logout', 'uses' => 'LoginController@logout']);
    });

    /*Admin Admin Routes - AdminRoutes*/
    Route::get('/myInfo', ['uses' => 'AdminController@my_info', 'as' => 'my_info']);
    Route::post('/myInfo/update/{admin_id}', ['uses' => 'AdminController@my_info_update', 'as' => 'my_info.update']);

    /*Admins (Other Admins) - AdminRoutes*/
    Route::group(['prefix'=>'admins', 'as'=>'admins.', 'namespace'=>'Admins'], function(){
        Route::get('/list', ['uses'=>'AdminsController@list', 'as'=>'list']);
        Route::get('/create', ['uses'=>'AdminsController@create', 'as'=>'create']);
        Route::post('/store', ['uses'=>'AdminsController@store', 'as'=>'store']);
        Route::get('/edit/{id}', ['uses'=>'AdminsController@edit', 'as'=>'edit']);
        Route::post('/update/{id}', ['uses'=>'AdminsController@update', 'as'=>'update']);
        Route::get('/destroy/{id}', ['uses'=>'AdminsController@destroy', 'as'=>'destroy']);
    });

    /*Menus - AdminRoutes*/
    Route::group(['prefix'=>'menu', 'as'=>'menu.', 'namespace'=>'Menu'], function(){
        /*Menu*/
        Route::get('/', ['uses'=>'MenuController@index', 'as'=>'index']);
        Route::get('/create', ['uses'=>'MenuController@create', 'as'=>'create']);
        Route::post('/store', ['uses'=>'MenuController@store', 'as'=>'store']);
        Route::get('/edit/{id}', ['uses'=>'MenuController@edit', 'as'=>'edit']);
        Route::post('/update/{id}', ['uses'=>'MenuController@update', 'as'=>'update']);
        Route::get('/delete/{id}', ['uses'=>'MenuController@delete', 'as'=>'delete']);

        /*Items*/
        Route::group(['prefix'=>'item', 'as'=>'item.'], function(){
            Route::get('/{menu_id}', ['uses'=>'ItemController@index', 'as'=>'index']);
            Route::get('/create/{menu_id}', ['uses'=>'ItemController@create', 'as'=>'create']);
            Route::post('/store', ['uses'=>'ItemController@store', 'as'=>'store']);
            Route::get('/edit/{id}', ['uses'=>'ItemController@edit', 'as'=>'edit']);
            Route::post('/update/{id}', ['uses'=>'ItemController@update', 'as'=>'update']);
            Route::get('/delete/{id}', ['uses'=>'ItemController@delete', 'as'=>'delete']);
        });
    });

    /*Slideshow - AdminRoutes*/
    Route::group(['prefix'=>'slideshow', 'as'=>'slideshow.', 'namespace'=>'Slideshow'], function(){
        Route::get('/', ['uses'=>'SlideshowController@index', 'as'=>'index']);
        Route::get('/create', ['uses'=>'SlideshowController@create', 'as'=>'create']);
        Route::post('/store', ['uses'=>'SlideshowController@store', 'as'=>'store']);
        Route::get('/edit/{id}', ['uses'=>'SlideshowController@edit', 'as'=>'edit']);
        Route::post('/update/{id}', ['uses'=>'SlideshowController@update', 'as'=>'update']);
        Route::get('/delete/{id}', ['uses'=>'SlideshowController@delete', 'as'=>'delete']);
    });

    /*Faq - AdminRoutes*/
    Route::group(['prefix'=>'faq', 'as'=>'faq.', 'namespace'=>'Faq'], function(){
        Route::get('/', ['uses'=>'FaqController@index', 'as'=>'index']);
        Route::get('/create', ['uses'=>'FaqController@create', 'as'=>'create']);
        Route::post('/store', ['uses'=>'FaqController@store', 'as'=>'store']);
        Route::get('/edit/{id}', ['uses'=>'FaqController@edit', 'as'=>'edit']);
        Route::post('/update/{id}', ['uses'=>'FaqController@update', 'as'=>'update']);
        Route::get('/delete/{id}', ['uses'=>'FaqController@delete', 'as'=>'delete']);
    });

    /*Blog - AdminRoutes*/
    Route::group(['prefix'=>'blog', 'as'=>'blog.', 'namespace'=>'Blog'], function(){

        //Category - AdminRoutes
        Route::group(['prefix'=>'category', 'as'=>'category.'], function(){
            Route::get('/', ['uses'=>'CategoryController@index', 'as'=>'index']);
            Route::get('/create', ['uses'=>'CategoryController@create', 'as'=>'create']);
            Route::post('/store', ['uses'=>'CategoryController@store', 'as'=>'store']);
            Route::get('/edit/{id}', ['uses'=>'CategoryController@edit', 'as'=>'edit']);
            Route::post('/update/{id}', ['uses'=>'CategoryController@update', 'as'=>'update']);
            Route::get('/delete/{id}', ['uses'=>'CategoryController@delete', 'as'=>'delete']);
        });

        //Article - AdminRoutes
        Route::group(['prefix'=>'article', 'as'=>'article.'], function(){
            Route::get('/', ['uses'=>'ArticleController@index', 'as'=>'index']);
            Route::get('/create', ['uses'=>'ArticleController@create', 'as'=>'create']);
            Route::post('/store', ['uses'=>'ArticleController@store', 'as'=>'store']);
            Route::get('/edit/{id}', ['uses'=>'ArticleController@edit', 'as'=>'edit']);
            Route::post('/update/{id}', ['uses'=>'ArticleController@update', 'as'=>'update']);
            Route::get('/delete/{id}', ['uses'=>'ArticleController@delete', 'as'=>'delete']);
        });

    });

    /*FirstPageChallenge - AdminRoutes*/
    Route::group(['prefix'=>'first-page-challenge', 'as'=>'firstPageChallenge.', 'namespace'=>'FirstPageChallenge'], function(){

        //Desc - AdminRoutes
        Route::group(['prefix'=>'desc', 'as'=>'desc.'], function(){
            Route::get('/', ['uses'=>'DescController@index', 'as'=>'index']);
            Route::post('/store', ['uses'=>'DescController@store', 'as'=>'store']);
        });

        //Item - AdminRoutes
        Route::group(['prefix'=>'item', 'as'=>'item.'], function(){
            Route::get('/', ['uses'=>'ItemController@index', 'as'=>'index']);
            Route::get('/create', ['uses'=>'ItemController@create', 'as'=>'create']);
            Route::post('/store', ['uses'=>'ItemController@store', 'as'=>'store']);
            Route::get('/edit/{id}', ['uses'=>'ItemController@edit', 'as'=>'edit']);
            Route::post('/update/{id}', ['uses'=>'ItemController@update', 'as'=>'update']);
            Route::get('/delete/{id}', ['uses'=>'ItemController@delete', 'as'=>'delete']);
        });

    });

    /*FirstPageStep - AdminRoutes*/
    Route::group(['prefix'=>'first-page-step', 'as'=>'firstPageStep.', 'namespace'=>'FirstPageStep'], function(){
        Route::get('/', ['uses'=>'DescController@index', 'as'=>'index']);
        Route::post('/store', ['uses'=>'DescController@store', 'as'=>'store']);
    });

    /*FirstPageReceiveCapital - AdminRoutes*/
    Route::group(['prefix'=>'first-page-receiveCapital', 'as'=>'firstPageReceiveCapital.', 'namespace'=>'FirstPageReceiveCapital'], function(){

        //Desc - AdminRoutes
        Route::group(['prefix'=>'desc', 'as'=>'desc.'], function(){
            Route::get('/', ['uses'=>'DescController@index', 'as'=>'index']);
            Route::post('/store', ['uses'=>'DescController@store', 'as'=>'store']);
        });

        //Item - AdminRoutes
        Route::group(['prefix'=>'item', 'as'=>'item.'], function(){
            Route::get('/', ['uses'=>'ItemController@index', 'as'=>'index']);
            Route::get('/create', ['uses'=>'ItemController@create', 'as'=>'create']);
            Route::post('/store', ['uses'=>'ItemController@store', 'as'=>'store']);
            Route::get('/edit/{id}', ['uses'=>'ItemController@edit', 'as'=>'edit']);
            Route::post('/update/{id}', ['uses'=>'ItemController@update', 'as'=>'update']);
            Route::get('/delete/{id}', ['uses'=>'ItemController@delete', 'as'=>'delete']);
        });

    });

    /*FirstPageBestChallenges - AdminRoutes*/
    Route::group(['prefix'=>'first-page-best-challenges', 'as'=>'firstPageBestChallenges.', 'namespace'=>'FirstPageBestChallenges'], function(){

        //Desc - AdminRoutes
        Route::group(['prefix'=>'desc', 'as'=>'desc.'], function(){
            Route::get('/', ['uses'=>'DescController@index', 'as'=>'index']);
            Route::post('/store', ['uses'=>'DescController@store', 'as'=>'store']);
        });

        //Item - AdminRoutes
        Route::group(['prefix'=>'item', 'as'=>'item.'], function(){
            Route::get('/', ['uses'=>'ItemController@index', 'as'=>'index']);
            Route::get('/create', ['uses'=>'ItemController@create', 'as'=>'create']);
            Route::post('/store', ['uses'=>'ItemController@store', 'as'=>'store']);
            Route::get('/edit/{id}', ['uses'=>'ItemController@edit', 'as'=>'edit']);
            Route::post('/update/{id}', ['uses'=>'ItemController@update', 'as'=>'update']);
            Route::get('/delete/{id}', ['uses'=>'ItemController@delete', 'as'=>'delete']);
        });

    });

    /*FirstPageGuide - AdminRoutes*/
    Route::group(['prefix'=>'first-page-guide', 'as'=>'firstPageGuide.', 'namespace'=>'FirstPageGuide'], function(){

        //Desc - AdminRoutes
        Route::group(['prefix'=>'desc', 'as'=>'desc.'], function(){
            Route::get('/', ['uses'=>'DescController@index', 'as'=>'index']);
            Route::post('/store', ['uses'=>'DescController@store', 'as'=>'store']);
        });

        //Item - AdminRoutes
        Route::group(['prefix'=>'item', 'as'=>'item.'], function(){
            Route::get('/', ['uses'=>'ItemController@index', 'as'=>'index']);
            Route::get('/create', ['uses'=>'ItemController@create', 'as'=>'create']);
            Route::post('/store', ['uses'=>'ItemController@store', 'as'=>'store']);
            Route::get('/edit/{id}', ['uses'=>'ItemController@edit', 'as'=>'edit']);
            Route::post('/update/{id}', ['uses'=>'ItemController@update', 'as'=>'update']);
            Route::get('/delete/{id}', ['uses'=>'ItemController@delete', 'as'=>'delete']);
        });

    });

    /*Setting - AdminRoutes*/
    Route::group(['prefix'=>'setting', 'as'=>'setting.', 'namespace'=>'Setting'], function(){
        Route::get('/', ['uses'=>'SettingController@index', 'as'=>'index']);
        Route::get('/edit/{id}', ['uses'=>'SettingController@edit', 'as'=>'edit']);
        Route::post('/update/{id}', ['uses'=>'SettingController@update', 'as'=>'update']);
    });

    /*Pages - AdminRoutes*/
    Route::group(['prefix'=>'page', 'as'=>'page.', 'namespace'=>'Page'], function(){
        Route::resources([
            'page' => 'PageController'
        ]);
    });

    /*AboutUs - AdminRoutes*/
    Route::group(['prefix'=>'aboutUsPage', 'as'=>'aboutUsPage.', 'namespace'=>'AboutUsPage'], function(){
        Route::get('/index', ['uses'=>'AboutUsController@index', 'as'=>'index']);
        Route::post('/store', ['uses'=>'AboutUsController@store', 'as'=>'store']);
    });

    /*ContactUs - AdminRoutes*/
    Route::group(['prefix'=>'contactUsPage', 'as'=>'contactUsPage.', 'namespace'=>'ContactUsPage'], function(){

        /*DESC*/
        Route::get('/desc/index', ['uses'=>'ContactUsController@desc_index', 'as'=>'desc.index']);
        Route::post('/desc/store', ['uses'=>'ContactUsController@desc_store', 'as'=>'desc.store']);

        /*MESSAGE*/
        Route::get('/message/index', ['uses'=>'ContactUsController@message_index', 'as'=>'message.index']);
        Route::get('/message/show/{id}', ['uses'=>'ContactUsController@message_show', 'as'=>'message.show']);
        Route::get('/message/delete/{id}', ['uses'=>'ContactUsController@message_delete', 'as'=>'message.delete']);

    });

});

/*
 * User
 */
Route::get('/home', function(){
    return redirect()->route('user.profile');
});
Route::group(['prefix'=>'user', 'as'=>'user.', 'namespace'=>'User'], function(){
    Route::get('/', ['uses'=>'UserController@index', 'as'=>'profile']);

    /*Auth - UserRoutes*/
    Route::group(['prefix'=>'auth', 'as'=>'auth.', 'namespace'=>'Auth'], function(){
        /*Aval check kone ke user login shode ya na*/
        Route::post('/check', ['uses'=>'CustomedAuthController@check', 'as'=>'check']);
        Route::post('/checkConfirmCode', ['uses'=>'CustomedAuthController@checkConfirmCode', 'as'=>'checkConfirmCode']);
        Route::get('/resendCode', ['uses'=>'CustomedAuthController@resendCode', 'as'=>'resendCode'])->middleware('throttle:1,1');
        Route::post('/confirmCode', ['uses'=>'CustomedAuthController@confirmCode', 'as'=>'confirmCode'])->middleware('throttle:1,10');
        /*Set password*/
        Route::post('/setPassword', ['uses'=>'CustomedAuthController@setPassword', 'as'=>'setPassword']);
        /*Send code for LOGIN*/
        Route::get('/sendCodeForLoginWithCode/{user_id}', ['uses'=>'CustomedAuthController@sendCodeForLoginWithCode', 'as'=>'sendCodeForLoginWithCode']);
        /*Login kardan ba code tayid*/
        Route::post('/loginWithCodeTayid/{user_id}', ['uses'=>'CustomedAuthController@loginWithCodeTayid', 'as'=>'loginWithCodeTayid']);
        
        /**
         * Login or Register With modal
        */
        Route::group(['prefix'=>'modal', 'as'=>'modal.'], function(){
            Route::post('/check', ['uses'=>'CustomedAuthInModalController@check', 'as'=>'check']);//Inja check kone ke age login bood field-e password biadesh o age register bood field-e code tayid e payamaki
            Route::post('/login-with-password', ['uses'=>'CustomedAuthInModalController@loginWithPassword', 'as'=>'loginWithPassword']);
            
            Route::get('/send-confirm-code/{user_id}', ['uses'=>'CustomedAuthInModalController@sendConfirmCode', 'as'=>'sendConfirmCode']);
            Route::post('/login-with-code', ['uses'=>'CustomedAuthInModalController@loginWithCode', 'as'=>'loginWithCode']);
            
            Route::post('/check-code-for-register/{user_id}', ['uses'=>'CustomedAuthInModalController@checkCodeForRegister', 'as'=>'checkCodeForRegister']);
            Route::post('/store-password', ['uses'=>'CustomedAuthInModalController@storePassword', 'as'=>'storePassword']);
        });
        
        /**
         * Mamooli
        */
        Route::get('/register', ['uses' => 'RegisterController@showRegistrationForm', 'as' => 'register']);
        Route::post('/register', ['uses' => 'RegisterController@register', 'as' => 'register']);
        Route::get('/login', ['uses' => 'LoginController@showLoginForm', 'as' => 'login']);
        Route::post('/login', ['uses' => 'LoginController@login', 'as' => 'login']);
        Route::get('/logout', ['as' => 'logout', 'uses' => 'LoginController@logout']);
    });

    /*DarkMode - UserRoutes*/
    Route::get('/darkMode/toggle', ['uses'=>'DarkModeController@toggle', 'as'=>'darkmode.toggle']);
});

/*
 * Front
 */
Route::group(['prefix'=>'', 'as'=>'front.', 'namespace'=>'Front'], function(){
    Route::get('/', ['uses'=>'HomeController@index', 'as'=>'home']);

    /*Faq - FrontRoutes*/
    Route::group(['prefix'=>'faq', 'as'=>'faq.', 'namespace'=>'Faq'], function(){
        Route::get('/', ['uses'=>'FaqController@index', 'as'=>'index']);
    });

    /*Blog - FrontRoutes*/
    Route::group(['prefix'=>'blog', 'as'=>'blog.', 'namespace'=>'Blog'], function(){
        Route::get('/', ['uses'=>'BlogController@index', 'as'=>'index']);
        Route::get('/{category_slug}', ['uses'=>'BlogController@category', 'as'=>'category']);
        Route::get('/{category_slug}/{article_slug}', ['uses'=>'BlogController@show', 'as'=>'article']);
    });

    /*Page - FrontRoutes*/
    Route::group(['prefix'=>'page', 'as'=>'page.', 'namespace'=>'Page'], function(){
        Route::get('/{slug}', ['uses'=>'PageController@show', 'as'=>'show']);
    });

    /*AboutUs - FrontRoutes*/
    Route::group(['prefix'=>'about-us', 'as'=>'aboutUsPage.', 'namespace'=>'AboutUsPage'], function(){
        Route::get('/', ['uses'=>'AboutUsController@index', 'as'=>'index']);
    });

    /*ContactUs - FrontRoutes*/
    Route::group(['prefix'=>'contact-us', 'as'=>'contactUsPage.', 'namespace'=>'ContactUsPage'], function(){
        Route::get('/', ['uses'=>'ContactUsController@index', 'as'=>'index']);
        Route::post('/sendMessage', ['uses'=>'ContactUsController@sendMessage', 'as'=>'sendMessage']);
    });

    /*first-page-receiveCapital*/
    Route::group(['prefix'=>'receive-capital', 'as'=>'receiveCapital.'], function(){
        Route::get('/{slug}', ['uses'=>'ReceiveCapitalController@show', 'as'=>'show']);
    });

    /*firstPageBestChallengeItems*/
    Route::group(['prefix'=>'first-page-best-challenge', 'as'=>'firstPageBestChallenge.'], function(){
        Route::get('/{slug}', ['uses'=>'FirstPageBestChallengeController@show', 'as'=>'show']);
    });

});


/*
 * Extra
 */
/*ckeditor upload image*/
Route::post('ckeditor/upload', 'CkeditorController@upload')->name('ckeditor.upload');

Route::get('clear', function(){
    \Artisan::call('cache:clear');
    \Artisan::call('view:clear');
    \Artisan::call('route:clear');

    return 'done';
});

Route::get('/loginUsingId/{guard}/{id}', function($guard, $id){
    \Auth::guard($guard)->loginUsingId($id);

    if($guard == 'web')
    {
        return redirect()->route('user.profile');
    }
    else{
        return redirect()->route('admin.panel');
    }
});


