<!DOCTYPE html>
<html dir="rtl">
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="theme-color" content="#00b2ca">
    @yield('meta')

    <title>
        پراپ فا
        |
        @yield('title')
    </title>

    <link rel="stylesheet" href="{{ asset('FrontTmpAssets/css/main.min.css') }}"/>
    <link rel="stylesheet" href="{{ asset('FrontTmpAssets/css/template.css') }}?v=1.02"/>
    @yield('head')

    <style>
        /*Hide Arrows in number inputs*/
        /* Chrome, Safari, Edge, Opera */
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }
        /*End Of Hide Arrows in number inputs*/

        .div-hasHref{
            cursor: pointer;
        }
        .err_labels{
            width: 100%;
            text-align: center;
            color: red;
            font-weight: bold;
            /*text-shadow: 0px 4px 4px orange;*/
            display: none;
        }

        /*New Loader*/
        .input-karnakon{
            background: lightgrey;
            pointer-events: none;
        }
        .new_waiter{
            text-align: center;
            width: 20%;
            background: lightgrey;
            position: fixed;
            height: 30%;
            right: 40%;
            top: 45%;
            z-index: 1000000699;
            border-radius: 10px;
            display: none;
        }
        .new_waiter>label{
            font-weight: bold;
            padding-top: 10%;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            color: #ffd101;
            text-shadow: 0px 0px 4px black;
            width: 100%;
            text-align: center;
        }
        @media only screen and (max-width: 600px) {
            .new_waiter{
                text-align: center;
                width: 90%;
                background: lightgrey;
                position: fixed;
                height: 30%;
                right: 5%;
                top: 45%;
                z-index: 1000000699;
                border-radius: 10px;
                display: none;
            }
            .new_waiter>label{
                font-weight: bold;
                color: grey;
                padding-top: 10%;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }
        }
        .loading7 {
            position: relative;
            border: 5px double #172d5a;
            width: 50px;
            height: 50px;
            margin: 10px auto;
            border-radius: 50%;
            box-sizing: initial;
            border-top-color: transparent;
            border-bottom-color: transparent;
            animation-name: loading3;
            animation-duration: 1200ms;
            animation-iteration-count: infinite;
            -webkit-animation-timing-function: linear;
        }
        .loading7:after {
            content: "";
            position: absolute;
            border: 5px double #172d5a;
            border-top-color: transparent;
            border-bottom-color: transparent;
            width: 36px;
            height: 36px;
            top: 2px;
            left: 2px;
            margin: auto;
            border-radius: 50%;
            box-sizing: initial;
            animation-name: loading7;
            animation-duration: 600ms;
            animation-iteration-count: infinite;
            -webkit-animation-timing-function: linear;
        }
        .loading7 .extra {
            position: relative;
            border: 5px double #0d1c3b;
            width: 25px;
            height: 25px;
            margin: 7px auto;
            border-radius: 50%;
            box-sizing: initial;
            border-top-color: transparent;
            border-bottom-color: transparent;
            animation-name: loading3;
            animation-duration: 1200ms;
            animation-iteration-count: infinite;
            -webkit-animation-timing-function: linear;
            display: flex;
            justify-content: center;
            align-items: center;
            align-content: center;
        }
        .loading7 .extra:after {
            content: "";
            position: relative;
            border: 5px double #172d5a;
            border-top-color: transparent;
            border-bottom-color: transparent;
            width: 20px;
            height: 20px;
            /* top: 2px; */
            /* left: 2px; */
            margin: auto;
            border-radius: 50%;
            box-sizing: border-box;
            animation-name: loading7;
            animation-duration: 300ms;
            animation-iteration-count: infinite;
            -webkit-animation-timing-function: linear;

        }
        @keyframes loading7 {
            0% {
                transform: rotate(360deg);
                -ms-transform: rotate(360deg);
            }
            100% {
                transform: rotate(0deg);
                -ms-transform: rotate(0deg);
            }
        }
        @-webkit-keyframes loading7 {
            0% {
                transform: rotate(360deg);
                -ms-transform: rotate(360deg);
            }
            100% {
                transform: rotate(0deg);
                -ms-transform: rotate(0deg);
            }
        }
        /*End Of New Loader*/

        /*Slim-select*/
        .ss-list{
            text-align: right !important;
        }
        .ss-search input{
            text-align: right !important;
        }
        .ss-value-delete{
            color: white;
            border-radius: 100px;
            text-align: center;
            font-weight: bold;
            background: #cc4e4e;
            margin-right: 2px;
            padding: 0px 7px 0px 7px;
            box-shadow: 0px 0px 3px 0px red;
        }
    </style>
    @yield('style')

</head>

<body>
    @include('Front.Partials.header')

    <div class="container-fluid body-content ps-0 pe-0">
        @yield('body')
        @include('Front.Partials.footer')
    </div>

    <!-- search modal -->
    <div class="modal fade" id="searchModal" tabindex="-1" aria-labelledby="searchModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl  modal-fullscreen-sm-down">
            <div class="modal-content">
                <div class="modal-header d-xl-none d-lg-none">
                    <h5 class="modal-title" id="searchModalLabel">جستجو</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body container search-modal__body">
                    <div class="row">
                        <div class="col-md-10 col-12 mt-3">
                            <input type="text" placeholder="جستجو در سایت ..." class="search-input form-control" id="">
                        </div>
                        <div class="col-md-2 col-12 mt-3">
                            <button type="button" class="btn btn-ls-blue rounded-pill">پیدا کن
                            </button>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Register Modal -->
    @include('Front.Partials.registerLoginModal')

    {{--New_waiter--}}
    <div class="new_waiter">
        <label class="waiter_title"></label>
        <br/>
        <div class="waiting-contain">
            <div class="loading7">
                <div class="extra"></div>
            </div>
        </div>
    </div>

    {{-- Scripts --}}
    <script src="{{ asset('FrontTmpAssets/js/main-min.js') }}"></script>
    <script src="{{ asset('FrontTmpAssets/js/script.js') }}"></script>

    {{--New_waiter--}}
    <script>
        function fnctn_loadWaiter(txt){
            $(".new_waiter").find('label').text(txt);
            $(".new_waiter").fadeIn("fast");
            $('button').prop('disabled', true);
            $('a').prop('disabled', true);
            $('input').addClass('input-karnakon');
            $('.allPage').css('opacity', '0.5');
        }
        function fnctn_unloadWaiter(){
            $(".new_waiter").fadeOut("fast");
            $('button').prop('disabled', false);
            $('a').prop('disabled', false);
            $('input').removeClass('input-karnakon');
            $('.allPage').css('opacity', '1');
        }
    </script>

    {{--SWEET ALERT--}}
    <script src="{{asset('js/sweet_alert/sweet_alert_2@9.js')}}"></script>
    
    <!-- Register Modal (scripts) -->
    @include('Front.Partials.registerLoginModal_scripts')

    @yield('script_whole')

</body>

</html>
