@extends('Front.Layouts.app')
@section('meta')
    <meta name="keywords" content="{{ $item->seo_keywords ?? '' }}" />
    <meta name="description" content="{{ $item->seo_description ?? '' }}" />
    <meta property="og:title" content="{{ $item->seo_title ?? '' }}" />
    <meta property="og:description" content="{{ $item->seo_description ?? '' }}" />
    <meta property="og:type" content="website" />
    <meta property="og:locale" content="fa_IR" />
    <meta property="og:image" content="{{ asset($setting->header_logo ?? '') }}" />
    <meta name="twitter:title" content="{{ $item->seo_title ?? '' }}"/>
    <meta name="twitter:description" content="{{ $item->seo_description ?? '' }}" />
    <meta name="twitter:image" content="{{ asset($setting->header_logo ?? '') }}" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="@parhoonsazeh" />
    <meta name="twitter:creator" content="@parhoonsazeh" />
    <meta property="og:url" content="{{ route('front.page.show', ['slug'=>$item->slug ?? ' ']) }}">
    <link rel="canonical" href="{{ route('front.page.show', ['slug'=>$item->slug ?? ' ']) }}" />
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="theme-color" content="#252525">
    <link rel="shortcut icon" href="{{ asset($setting->header_logo ?? '') }}" type=image/x-icon>
    <meta name="robots" content="index,follow" />
@endsection
@section('title', $item->title)
@section('head') @endsection
@section('style')
    <style>
        .mainContent {
            padding: 10px !important;
            min-height: 400px;
        }

        .post-title {
            font-size: 15px;
            height: 60px;
            overflow: hidden;
            font-weight: bold;
            color: black;
        }

        .date {
            float: right;
            font-weight: bold;
            font-size: 10px;
            text-align: right;
        }

        .similar-post-thumb img {
            height: 90px;
            width: 100%;
            object-fit: cover;
            border-radius: 5px;
        }

        .each-similar-article {
            background: #eaebee;
            padding: 5px;
            border-radius: 5px;
        }

        img{
            max-width: 100% !important;
        }
    </style>
@endsection
@section('body')

    <section class="container-fluid catalog-section">
        <div class="container p-0">
            <div class="row align-items-center">
                <div class="col-md-12 col-12 ps-0">
                    <h1 class="title-section wow fadeInUp">
                        {{ $item->title ?? '' }}
                    </h1>
                </div>
            </div>
            <div class="row">
                <div class="col-12 p-0 wow fadeInUp">
                    <img src="{{ asset($item->header_image ?? '') }}" style="max-width: 100%;">
                </div>
                <div class="col-12 pt-3 wow fadeInUp">
                    @if(!empty($item->text))
                        {!! $item->text !!}
                    @endif
                </div>
            </div>
        </div>
    </section>


@endsection
@section('script_whole') @endsection
