@extends('Front.Layouts.app')
@section('meta')
    <meta name="keywords" content="{{ $contactUs->seo_keywords ?? '' }}" />
    <meta name="description" content="{{ $contactUs->seo_description ?? '' }}" />
    <meta property="og:title" content="{{ $contactUs->seo_title ?? '' }}" />
    <meta property="og:description" content="{{ $contactUs->seo_description ?? '' }}" />
    <meta property="og:type" content="website" />
    <meta property="og:locale" content="fa_IR" />
    <meta property="og:image" content="{{ asset($setting->header_logo ?? '') }}" />
    <meta name="twitter:title" content="{{ $contactUs->seo_title ?? '' }}"/>
    <meta name="twitter:description" content="{{ $contactUs->seo_description ?? '' }}" />
    <meta name="twitter:image" content="{{ asset($setting->header_logo ?? '') }}" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="@parhoonsazeh" />
    <meta name="twitter:creator" content="@parhoonsazeh" />
    <meta property="og:url" content="{{ route('front.contactUsPage.index') }}">
    <link rel="canonical" href="{{ route('front.contactUsPage.index') }}" />
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="theme-color" content="#252525">
    <link rel="shortcut icon" href="{{ asset($setting->header_logo ?? '') }}" type=image/x-icon>
    <meta name="robots" content="index,follow" />
@endsection
@section('title', __('labels.contact_us'))
@section('head') @endsection
@section('style') @endsection
@section('body')
    <link rel="stylesheet" href="{{asset('FrontTmpAssets/css/contact.css')}}"/>


    <section class="container-fluid py-3"></section>
    <section class="customer">
        <div class="col-12 wow fadeInUp ">

            @if($contactUs->slideshow_status)
                <div class="contact-hero-section">
                    <div class="contact-hero-bg-wrapper">
                        <div class="p_container contact">
                            <h1 class="p_heading">
                                {{ $contactUs->slideshow_title ?? '' }}
                            </h1>
                            <div class="contact-block-wrapper">
                                @if(!empty($contactUs->slideshow_items))
                                    @if(!empty(json_decode($contactUs->slideshow_items)))
                                        @php
                                            $items = json_decode($contactUs->slideshow_items);
                                            $items = collect($items)->sortBy('sort_order');
                                        @endphp
                                        @if(!empty($items))
                                            @if(count($items))
                                                @foreach($items as $item)
                                                    <div class="contact-block">
                                                        <img src="{{$item->image ?? ''}}" alt="" class="contact-icon">
                                                        <h2>
                                                            {{ $item->title ?? '' }}
                                                        </h2>
                                                        <p>
                                                            {{ $item->text ?? '' }}
                                                        </p>
                                                        <a href="{{$item->button_link ?? ''}}" class="p_btn w-button">
                                                            {{ $item->button_title ?? '' }}
                                                        </a>
                                                    </div>
                                                @endforeach
                                            @endif
                                        @endif
                                    @endif
                                @endif
                            </div>
                        </div>
                        <div class="contact-image-div" style="background-image: linear-gradient(90deg, #222, rgba(34, 34, 34, 0.18) 76%), url('https://bahnid.nonegar3.ir/FrontTmpAssets/images/ctu.jpg')"></div>
                    </div>
                </div>
            @endif

            <div id="contact" class="content-section ">
                <div class="p_container">
                    <div class="contact-wrapper">
                        <div class="contact-left">
                            {!! $contactUs->body_one ?? '' !!}
                        </div>
                        <div class="contact-right">

                            {!! $contactUs->body_two ?? '' !!}

                            <div class="w-form">
                                <form action="{{route('front.contactUsPage.sendMessage')}}" method="post" id="email-form" name="email-form" data-name="Email Form" class="email-form">
                                    {{ csrf_field() }}

                                    <label for="name">
                                        {{ __('labels.name') }}
                                    </label>
                                    <input type="text" class=" w-input" maxlength="256" name="name" data-name="Name" id="name" required>

                                    <label for="email">
                                        {{ __('labels.email') }}
                                    </label>
                                    <input type="email" class=" w-input" maxlength="256" name="email" data-name="Email" id="email" required="">

                                    <label for="Message">
                                        {{ __('labels.message') }}
                                    </label>
                                    <textarea maxlength="5000" id="Message" name="message" data-name="Message" class=" w-input" required></textarea>
                                    <input type="submit" value="{{__('labels.send')}}" data-wait="Please wait..." class="p_btn w-button align-self-baseline">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

@endsection
@section('script_whole')
    <script>
        $("#email-form").on("submit", function(e){
            e.preventDefault();

            var thisForm = $(this);

            fnctn_loadWaiter("{{__('labels.ajax_sending')}}");
            var data = $(this).serialize();
            var url = $(this).attr('action');
            var type = $(this).attr('method');

            $.ajax({
                data:data,
                type:type,
                url:url,
                success:function(){
                    fnctn_unloadWaiter();

                    Swal.fire({
                        icon: 'success',
                        title: '',
                        text: "{{__('labels.stored')}}",
                        confirmButtonText: "{{__('labels.alert_confirm_button')}}"
                    });

                    thisForm.find('input').prop('disabled', true);
                    thisForm.find('textarea').prop('disabled', true);
                    thisForm.find('button').prop('disabled', true);
                },
                error:function(err){
                    fnctn_unloadWaiter();
                }
            });
        });
    </script>
@endsection
