<div class="col-lg-4">
    <div class="card mb-4">
        <div class="card-header">جستجو</div>
        <div class="card-body">
            <form method="GET" action="{{ $action }}">
                <div class="input-group">
                    <input class="form-control"
                           type="text"
                           name="search"
                           value="{{ request('search') }}"
                           placeholder="عبارت جستجو را وارد کنید"
                           aria-label="عبارت جستجو را وارد کنید"
                           aria-describedby="button-search" />
                    <button class="btn btn-primary" id="button-search" type="submit">بگرد!</button>
                </div>
            </form>
        </div>
    </div>
    @if(!empty($categories))
        @if(count($categories))
            <div class="card mb-4">
                <div class="card-header">دسته‌ها</div>
                <div class="card-body">
                    <div class="row">
                        @foreach($categories->chunk(ceil(count($categories)/2)) as $chunkedCat)
                            <div class="col-sm-6">
                                <ul class="list-unstyled mb-0">
                                    @foreach($chunkedCat as $category)
                                        <li>
                                            <a href="{{ $category->path() }}" class="text-decoration-underline">
                                                {{ $category->name }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
    @endif
    @if($show_widgets)
        <div class="card mb-4">
            <div class="card-header">ویجت‌ها</div>
            <div class="card-body">
                <div class="row text-center" style="font-size: 30px;">
                    <div class="col-3">
                        <a class="text-primary"
                           href="https://t.me/share/url?url={{ url()->full() }}&text={{ $article->title }}"
                           rel="nofollow"
                           title="اشتراک‌گذاری با تلگرام">
                            <i class="fab fa-telegram"></i>
                        </a>
                    </div>
                    <div class="col-3">
                        <a class="text-success"
                           href="whatsapp://send?text={{ url()->full() }}"
                           data-action="share/whatsapp/share"
                           rel="nofollow"
                           title="اشتراک‌گذاری با واتساپ">
                            <i class="fab fa-whatsapp"></i>
                        </a>
                    </div>
                    <div class="col-3">
                        <a class="text-info"
                           href="https://twitter.com/home?status={{ url()->full() }}"
                           rel="nofollow"
                           title="اشتراک‌گذاری با توئیتر">
                            <i class="fab fa-twitter"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
