@extends('Front.Layouts.app')
@section('meta') @endsection
@section('title', $article->title ?? '')
@section('head')
    <link rel="stylesheet" href="{{ asset('css/blog.css') }}"/>
@endsection
@section('body')
    <article class="container-fluid inner-page">
    <div class="container">
       <div class="row">
           <div class="col-12 p-0 mt-5 mb-5">
               <div class="card">
                   <div class="card-body">
                        <div class="row">
            <div class="col-lg-8">
                <!-- Post content-->
                <article>
                    <!-- Post header-->
                    <header class="mb-4">
                        <!-- Post title-->
                        <h1 class="fw-bolder mb-1">{{ $article->title }}</h1>
                        <!-- Post meta content-->
                        <div class="text-muted fst-italic mb-2">نوشته شده در
                            {{ convert_to_jalali($article->created_at->toDateString()) }}
                        </div>
                        <!-- Post categories-->
                        @foreach($categories as $category)
                            <a class="badge bg-secondary text-decoration-none link-light"
                               href="{{ $category->path() }}">
                                {{ $category->name }}
                            </a>
                        @endforeach
                    </header>
                    @if($article->image)
                        <!-- Preview image figure-->
                        <figure class="mb-4">
                            <img class="img-fluid rounded"
                                 src="{{ asset($article->header_image ?? 'images/no_pic.png') }}"
                                 alt="{{ $article->title }}" />
                        </figure>
                    @endif
                    <!-- Post content-->
                    <section class="mb-5 text">{!! $article->text !!}</section>
                </article>
                <!-- Comments section-->
                <section class="mb-5">
                    <div class="card bg-light"></div>
                </section>
            </div>
            @include('Front.Blog.sidebar', [ 'action' => route('front.blog.index'), 'show_widgets' => true ])
        </div>
                   </div>
               </div>
           </div>
       </div>
    </div>
    </article>
@endsection
@section('script_whole') @endsection
