@extends('Front.Layouts.app')
@section('meta') @endsection
@section('title', 'وبلاگ')
@section('head')
    <link rel="stylesheet" href="{{ asset('css/blog.css') }}"/>
@endsection
@section('body')
    <div class="pb-3 pt-2">
        <header class="py-3 bg-light border-bottom mb-4">
            <div class="container">
                <div class="text-center my-5">
                    <h1 class="fw-bolder">
                        {{ $title ?? 'وبلاگ' }}
                    </h1>
                    <p class="lead mb-0">
                        {{ $description ?? '' }}
                    </p>
                </div>
            </div>
        </header>
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    @if($featured)
                        <div class="card mb-4">
                            @if($featured->image)
                                <a href="{{ $featured->path() }}">
                                    <img class="card-img-top"
                                         src="{{ asset($featured->image ?? '' ) }}"
                                         alt="{{ $featured->title }}" />
                                </a>
                            @endif
                            <div class="card-body">
                                <div class="small text-muted">
                                    {{ convert_to_jalali($featured->created_at->toDateString()) }}
                                </div>
                                <h2 class="card-title">{{ $featured->title }}</h2>
                                <p class="card-text">{{ $featured->description }}</p>
                                <a class="btn btn-primary" href="{{ $featured->path() }}">
                                    ادامه مقاله
                                </a>
                            </div>
                        </div>
                    @endif
                    @if(count($articles))
                        <div class="row">
                            @foreach($articles->chunk(ceil(count($articles)/2)) as $chunkedArticle)
                                <div class="col-lg-6">
                                    @foreach($chunkedArticle as $article)
                                        <div class="card mb-4">
                                            @if($article->image)
                                                <a href="{{ $article->path() }}">
                                                    <img class="card-img-top"
                                                         src="{{ asset($article->image ?? '') }}"
                                                         alt="{{ $article->title }}" />
                                                </a>
                                            @endif
                                            <div class="card-body">
                                                <div class="small text-muted">
{{ convert_to_jalali($article->created_at->toDateString()) }}
                                                </div>
                                                <h2 class="card-title h4">{{ $article->title }}</h2>
                                                <p class="card-text">{{ $article->description }}</p>
<a class="btn btn-primary" href="{{ $article->path() }}">ادامه مقاله</a>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endforeach
                        </div>
                    @endif
                    @if(!$featured && !count($articles))
                        <div class="alert alert-danger" role="alert">
                            <span class="fa fa-ban"></span>
                            هیچ مقاله‌ای یافت نشد
                        </div>
                    @endif
                    {!! $articles->appends($_GET)->links() !!}
                </div>
                @include('Front.Blog.sidebar', [ 'action' => '', 'show_widgets' => false ])
            </div>
        </div>
    </div>
@endsection
@section('script_whole') @endsection
