@extends('Front.Layouts.app')
@section('meta') @endsection
@section('title', 'احراز هویت')
@section('head')
    {{--Google Captcha image challenge--}}
    <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit&hl=fa"></script>
@endsection
@section('style')
    <style>
        .frm-search{
            display: none;
        }
        .row-menu{
            height: 50px;
        }
        .account{
            display: none;
        }
        .col-3.p-0.text-md-end.d-none.d-lg-block{
            display: none !important;
        }
        /*Mine*/
        #header{
            /*overflow: hidden;*/
            background-color: #032370;
        }
        #header *{
            background-color: #032370;
        }
        #dropdownMenuButton1{
            font-size: 14px !important;
            font-weight: bold !important;
        }
        .fa-bars{
            color: white !important;
        }
        .banner-top{
            display: none;
        }
        .navIcon{
            display: none !important;
        }
        .time-supprt, .num{
            font-size: 14px !important;;
            color: white !important;
        }
        .login, .register{
            display: none !important;
        }
        #cssmenu1 li:not(:first-child){
            display: none;
        }

        @if(!empty($setting))
            @if(!empty($setting->auth_page_background_image))
                .right{
            background-image: url("{{asset($setting->auth_page_background_image ?? '')}}") !important;
            background-position: center !important;
            background-repeat: no-repeat !important;
            background-size: cover !important;
        }
        @endif
        @endif
        .p-rules{
            text-align: center;
            font-weight: bold;
            font-size: 16px;
        }
        .p-rules a{
            font-size: 20px;
        }
        .modalButton{
            width: 10%;
            font-size: 12px;
        }
        .swal2-title{
            font-size: 17px !important;
        }

        .btn-resendCode{
            width: 100%;
            text-align: center;
            border: none;
            background: none;
            font-size: 12px;
            font-weight: bold;
        }
        .click_off{
            pointer-events: none;
        }
        .buttonarea{
            text-align: center !important;
        }

        /*CodePen*/
        @charset "UTF-8";
        @import url("https://fonts.googleapis.com/css2?family=Dongle:wght@300;400;700&family=Montserrat:wght@400;500;700&family=Orbitron&family=Prompt:wght@400;500;700&display=swap");
        :root {
            --color-p: #3a5cd1;
            --color-white: #fff;
            --color-light-gray: #eff2f5;
            --color-mid-gray: #96a0b5;
            --color-dark-gray: #6d7d93;
            --color-dark: #182550;
            --color-red: #d13a3a;
        }

        h1 {
            font-size: 2.441rem;
            line-height: 1.4rem;
        }

        h2 {
            font-size: 1.953rem;
        }

        h3 {
            font-size: 1.563rem;
        }

        h4 {
            font-size: 1.25rem;
        }

        a {
            text-decoration: none;
            color: var(--color-p);
            transition: all 0.3s ease-out;
        }
        a:hover {
            color: var(--color-dark);
        }

        .text-center {
            text-align: center;
        }

        .text-underline {
            text-decoration: underline;
        }

        *,
        *:before,
        *:after {
            box-sizing: border-box;
        }

        html {
            font-size: 24px;
        }

        body {
            background: var(--color-white);
            color: var(--color-dark);
            font-size: 1‬rem;
            line-height: 1.3rem;
        }

        img{
            display: block;
            max-width: 100%;
            height: auto;
        }

        .wrapper {
            min-height: 88vh;
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            text-align: center;
        }

        .left {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 3rem;
            transition: all 0.3s ease-out;
        }
        .left h1 {
            font-weight: 700;
            margin-bottom: 1rem;
        }
        .left .social-buttons {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0.75rem;
            gap: 1rem;
        }
        .left .social-buttons a {
            padding: 8px;
            display: inline-block;
            background-color: var(--color-light-gray);
            border-radius: 4px;
        }

        .left-inner {
            display: flex;
            flex-flow: column wrap;
            width: 100%;
        }

        .seperator {
            position: relative;
        }
        .seperator:before {
            content: "";
            position: absolute;
            top: 38%;
            left: 0;
            z-index: 1;
            height: 1px;
            width: 100%;
            background-color: var(--color-mid-gray);
        }
        .seperator span {
            background-color: var(--color-white);
            padding: 0 1rem;
            display: inline-block;
            position: relative;
            z-index: 2;
            color: var(--color-mid-gray);
            margin-bottom: 0.5rem;
        }

        .form-group {
            margin-bottom: 1rem;
            text-align: left;
        }

        label {
            display: block;
            color: var(--color-dark-gray);
        }

        input {
            background-color: var(--color-light-gray);
            padding: 0.5rem;
            border: 1px solid transparent;
            width: 100%;
            border-radius: 6px;
            font-size: 1rem;
        }
        input:focus {
            color: var(--color-dark);
            background-color: var(--color-white);
            border-color: var(--color-p);
            outline: 0;
            border: 1px solid var(--color-p);
        }
        input.error {
            border: 1.5px solid var(--color-red);
        }

        .form-radio,
        .form-checkbox {
            appearance: none;
            display: inline-block;
            position: relative;
            background-color: var(--color-white);
            border: 2px solid #bdbcc0;
            height: 24px;
            width: 24px;
            border-radius: 50px;
            cursor: pointer;
            margin: 0 10px 0 0;
            outline: none;
            padding: 0;
        }

        .form-radio:checked::before,
        .form-checkbox:checked::before {
            position: absolute;
            left: 5px;
            top: 1px;
            content: "⅃";
            font-size: 14px;
            transform: rotate(40deg);
        }

        .form-radio:hover,
        .form-checkbox:hover {
            background-color: var(--color-mid-gray);
            outline: none;
        }

        .form-radio:checked,
        .form-checkbox:checked {
            background-color: var(--color-p);
            border-color: var(--color-dark);
            color: var(--color-white);
            z-index: 2;
        }

        .form-radio {
            border: 2px solid #bdbcc0;
            top: 6px;
        }

        .form-checkbox {
            border-radius: 4px;
        }

        .error-text {
            color: var(--color-red);
        }

        .remember-forgot {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .remember {
            display: flex;
            align-items: center;
        }
        .remember label {
            display: inline-block;
            line-height: 1;
        }

        .forgot {
            line-height: 1;
            text-align: right;
        }

        button {
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: var(--color-p);
            color: var(--color-white);
            border: 0;
            padding: 0.75rem;
            width: 100%;
            border-radius: 6px;
            font-weight: 700;
            font-size: 0.75rem;
            cursor: pointer;
            transition: all 0.3s ease-out;
        }
        button:hover {
            background-color: var(--color-dark);
        }

        .right {
            background: radial-gradient(82.76% 57.9% at 72.85% 4.95%, var(--color-p) 0%, var(--color-dark) 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--color-white);
            padding: 3rem;
        }
        .right h2 {
            font-weight: 700;
            margin-bottom: 1.5rem;
        }
        .right p {
            max-width: 50vw;
            margin: 0 auto;
            line-height: 1rem;
        }
        .right-inner{
            color: black;
        }

        .sign-in-form,
        .forgot-pass-form,
        .sign-up-form {
            display: none;
        }
        .sign-in-form.active,
        .forgot-pass-form.active,
        .sign-up-form.active {
            display: block;
        }

        .dark-mode-on .left {
            background-color: var(--color-dark);
            color: var(--color-white);
        }
        .dark-mode-on input {
            background-color: transparent;
            border: 1px solid var(--color-mid-gray);
        }
        .dark-mode-on .seperator span {
            background-color: var(--color-dark);
        }
        .dark-mode-on button:hover {
            background-color: var(--color-white);
            color: var(--color-dark);
        }

        @media screen and (max-width: 48rem) {
            .wrapper {
                grid-template-columns: 1fr;
            }

            .right {
                display: none;
            }
            .left{
                padding: 10px !important;
            }
        }



        /*Menu top*/
        .div-menuDesktop-header{
            background: #697375 !important;
            max-width: unset !important;
            padding: 0px 50px !important;
        }
    </style>
@endsection
@section('body')

    <div class="wrapper">
        <div class="left">
            <div class="left-inner">

                <div class="sign-in-form active" id="Dive-Form-Asli">
                    @if(\Auth::guard('web')->check())
                        @if(!empty(\Auth::guard('web')->user()->login_confirmation_code))
                            @if(!\Auth::guard('web')->user()->login_confirmation_code_verified)
                                @include('Front.Auth.Partials.confirmCode')
                            @else
                                @if(empty(\Auth::guard('web')->user()->password))
                                    @include('Front.Auth.Partials.setPassword')
                                @endif
                            @endif
                        @endif
                    @else
                        @include('Front.Auth.Partials.firstForm')
                    @endif
                </div>
            </div>

        </div>
        <div class="right">
            <div class="right-inner">
                <h2>
                    {{ $setting->auth_page_title ?? '' }}
                </h2>
                <p>
                    {!! $setting->auth_page_text ?? '' !!}
                </p>
            </div>
        </div>
    </div>

    {{--Rules modal--}}
    <div class="modal fade" id="rulesModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">شرایط و قوانین</h4>
                </div>
                <div class="modal-body">
                    @if(!empty($setting))
                        {!! $setting->login_rules ?? '' !!}
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary modalButton btn-closeModal" data-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script_whole')

    {{--Google captcha image challenge--}}
    <script>
        loadCaptcha();
        function loadCaptcha(){
            // setTimout is necessary
            $(document).ready(function() {
                setTimeout(function() {
                    $('.recaptcha').each(function() {
                        grecaptcha.render(this.id, {
                            'sitekey': '6LdVkwkUAAAAACeeETRX--v9Js0vWyjQOTIZxxeB',
                            "theme":"light"
                        });
                        flag = true;
                    });

                }, 500);
            });

            /*adding css to appended recaptcha*/
            $(document).ready(function() {
                setTimeout(function() {
                    $(".recaptcha").each(function(){
                        $(this).find('div').css('margin', '0 auto');
                    });
                }, 600);
            });
        }
        /*Check kone ke age captcha load nashode bood, Dobare darkhast she*/
        setInterval(function(){
            if(!$("#rc-anchor-container").length){
                /*if($("#rc-anchor-container").length != 0){*/
                loadCaptcha();
            }
        }, 2000);
    </script>

    {{--Rule modal--}}
    <script>
        $("#openRulesModal").on("click", function(e){
            e.preventDefault();
            $("#rulesModal").modal("show");
        });
        $(".btn-closeModal").on("click", function(){
            $("#rulesModal").modal("hide");
        });
    </script>

    {{--Frm-check Submit--}}
    <script>
        $(document).on("submit", "#frm-check", function(e){
            e.preventDefault();

            fnctn_loadWaiter('درحال بررسی اطلاعات');

            var data = $(this).serialize();
            var url = $(this).attr('action');
            var type = $(this).attr('method');

            $.ajax({
                data:data,
                url:url,
                type:type,
                success:function(html){
                    fnctn_unloadWaiter();

                    /*Agar niaz be payam e success bashe too khode oon blade ke dare miadesh hastesh*/

                    $("#Dive-Form-Asli").html('');
                    $("#Dive-Form-Asli").html(html);
                },
                error:function(err){
                    fnctn_unloadWaiter();

                    if(err.responseJSON.errors.mobile_or_email){
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        })

                        Toast.fire({
                            icon: 'error',
                            title: err.responseJSON.errors.mobile_or_email[0]
                        })

                        return false;
                    }
                    if(err.responseJSON.errors.captcha){
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        })

                        Toast.fire({
                            icon: 'error',
                            title: err.responseJSON.errors.captcha[0]
                        })

                        return false;
                    }
                }
            });
        });
    </script>

    {{--Attemt login--}}
    <script>
        $(document).on("submit", "#frm-loginWithPassword", function(e){
            e.preventDefault();

            fnctn_loadWaiter('درحال بررسی اطلاعات');

            var data = $(this).serialize();
            var url = $(this).attr('action');
            var type = $(this).attr('method');

            $.ajax({
                data:data,
                type:type,
                url:url,
                success:function(){
                    fnctn_unloadWaiter();

                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                    })
                    Toast.fire({
                        icon: 'success',
                        title: 'ورود به پنل کاربری انجام شد'
                    })

                    setTimeout(function(){
                        @if(\Session::has('lastUrlBeforeLoginOrRegister'))
                            window.location.href = "{{\Session::get('lastUrlBeforeLoginOrRegister')}}";
                        @else
                            window.location.href = "{{route('user.profile')}}";
                        @endif
                    }, 2500);
                },
                error:function(err){
                    fnctn_unloadWaiter();

                    if(err.responseJSON.errors.password){
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        })
                        Toast.fire({
                            icon: 'error',
                            title: err.responseJSON.errors.password[0]
                        })
                    }
                    if(err.responseJSON.errors.mobile_number){
                        if(err.responseJSON.errors.mobile_number[0] == 'These credentials do not match our records.'){
                            const Toast = Swal.mixin({
                                toast: true,
                                position: 'center',
                                showConfirmButton: false,
                                timer: 3000,
                                timerProgressBar: true,
                                didOpen: (toast) => {
                                    toast.addEventListener('mouseenter', Swal.stopTimer)
                                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                                }
                            })
                            Toast.fire({
                                icon: 'error',
                                title: 'رمز عبور صحیح نمی باشد'
                            })
                        }
                    }
                    console.log(err.responseJSON);
                }
            });
        });
    </script>

    {{--Go to login with code--}}
    <script>
        $(document).on("click", ".btn-goToLoginWithCode", function(e){
            e.preventDefault();

            fnctn_loadWaiter('درحال ارسال کد');
            var url = $(this).attr('href');
            var type = "get";

            $.ajax({
                data:'',
                type:type,
                url:url,
                success:function(html){
                    fnctn_unloadWaiter();

                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                    })
                    Toast.fire({
                        icon: 'success',
                        title: 'کد تایید برای شما ارسال شد'
                    })

                    $("#Dive-Form-Asli").html('');
                    $("#Dive-Form-Asli").html(html);
                },
                error:function(err){
                    fnctn_unloadWaiter();
                }
            });
        });
    </script>

    {{--Login with code--}}
    <script>
        $(document).on("submit", "#frm-loginWithCode", function(e){
            e.preventDefault();

            fnctn_loadWaiter('درحال بررسی کد');

            var data = $(this).serialize();
            var url = $(this).attr('action');
            var type = $(this).attr('method');

            $.ajax({
                data:data,
                type:type,
                url:url,
                success:function(){
                    fnctn_unloadWaiter();

                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                    })
                    Toast.fire({
                        icon: 'success',
                        title: 'ورود به پنل کاربری انجام شد'
                    })

                    setTimeout(function(){
                        @if(\Session::has('lastUrlBeforeLoginOrRegister'))
                            window.location.href = "{{\Session::get('lastUrlBeforeLoginOrRegister')}}";
                        @else
                            window.location.href = "{{route('user.profile')}}";
                        @endif
                    }, 2500);
                },
                error:function(err){
                    fnctn_unloadWaiter();

                    if(err.responseJSON == 'code_is_incorrect'){
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        })

                        Toast.fire({
                            icon: 'error',
                            title: 'کد وارد شده معتبر نمی باشد'
                        })
                    }
                    if(err.responseJSON.errors.code){
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        })

                        Toast.fire({
                            icon: 'error',
                            title: err.responseJSON.errors.code[0]
                        })

                        return false;
                    }
                }
            });
        });
    </script>

    {{--Set password--}}
    <script>
        $(document).on("submit", "#frm-setPassword", function(e){
            e.preventDefault();

            fnctn_loadWaiter('ثبت رمز عبور');

            var data = $(this).serialize();
            var url = $(this).attr('action');
            var type = $(this).attr('method');

            $.ajax({
                data:data,
                type:type,
                url:url,
                success:function(){
                    fnctn_unloadWaiter();

                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                    })
                    Toast.fire({
                        icon: 'success',
                        title: 'ثبت نام با موفقیت انجام شد'
                    })

                    setTimeout(function(){
                        @if(\Session::has('lastUrlBeforeLoginOrRegister'))
                            window.location.href = "{{\Session::get('lastUrlBeforeLoginOrRegister')}}";
                        @else
                            window.location.href = "{{route('user.profile')}}";
                        @endif
                    }, 2500);
                },
                error:function(err){
                    fnctn_unloadWaiter();

                    if(err.responseJSON.errors.password){
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        })
                        Toast.fire({
                            icon: 'error',
                            title: err.responseJSON.errors.password[0]
                        })
                    }
                }
            });
        });
    </script>

    {{--resend Code--}}
    <script>
        start_timer("2:10"); //vase avalin bar ejra she
        function start_timer(time){
            var html = '<a href="#" type="button" class="btn-resendCode click_off btn_sms_resend">';
            html += 'ارسال مجدد کد بعد از ';
            html += '<span class="countdown"></span> ';
            html += 'دقیقه';
            html += '</a>';
            $(".resendCode-buttonarea").html('');
            $(".resendCode-buttonarea").html(html);

            var timer2 = time;
            var interval = setInterval(function() {
                var timer = timer2.split(':');
                //by parsing integer, I avoid all extra string processing
                var minutes = parseInt(timer[0], 10);
                var seconds = parseInt(timer[1], 10);
                --seconds;
                minutes = (seconds < 0) ? --minutes : minutes;
                seconds = (seconds < 0) ? 59 : seconds;
                seconds = (seconds < 10) ? '0' + seconds : seconds;
                //minutes = (minutes < 10) ?  minutes : minutes;
                $('.countdown').html(minutes + ':' + seconds);
                if (minutes < 0) clearInterval(interval);
                //check if both minutes and seconds are 0
                if ((seconds <= 0) && (minutes <= 0)){
                    $(".btn_sms_resend").remove();
                    $(".resendCode-buttonarea").append('<a href="#" class="btn-resendCode btn_resend_code">ارسال مجدد کد</a>');
                }
                timer2 = minutes + ':' + seconds;
            }, 1000);
        }

        /* https://stackoverflow.com/questions/41035992/jquery-countdown-timer-for-minutes-and-seconds */

        $(document).on("click", ".btn_resend_code", function(e){
            e.preventDefault();
            fnctn_loadWaiter('ارسال مجدد کد');
            var url = "{{route('user.auth.resendCode')}}";
            $.ajax({
                data:'',
                url:url,
                type:"get",
                success:function(){
                    fnctn_unloadWaiter();
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'center',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                    })
                    Toast.fire({
                        icon: 'success',
                        title: 'کد تایید مجددا ارسال شد'
                    })
                    setTimeout(function(){
                        start_timer("2:10"); //mojadad Timer faal she
                    }, 1990);
                },
                error:function(){
                    fnctn_unloadWaiter();
                    console.log('err in sending new confirmation code');
                }
            });
        });
    </script>

    {{--frm-confirmCode e form--}}
    <script>
        $(document).on("submit", "#frm-confirmCode", function(e){
            e.preventDefault();

            fnctn_loadWaiter('درحال بررسی کد تایید');

            var data = $(this).serialize();
            var url = $(this).attr('action');
            var type = $(this).attr('method');

            $.ajax({
                data:data,
                type:type,
                url:url,
                success:function(array){
                    fnctn_unloadWaiter();

                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                    })
                    Toast.fire({
                        icon: 'success',
                        title: 'کد تایید باموفقیت ثبت شد'
                    })

                    if(array.whatToDo == 'goToUrl'){
                        /*Dar inja array az Controller oomade*/
                        setTimeout(function(){
                            window.location.href = array.url;
                        }, 2900);
                    }
                    else{
                        /*Dar inja array az Controller nayumade va hamun html hastesh*/
                        $("#Dive-Form-Asli").html('');
                        $("#Dive-Form-Asli").html(array);
                    }
                },
                error:function(err){
                    fnctn_unloadWaiter();

                    if(err.responseJSON == 'code_is_incorrect'){
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        })

                        Toast.fire({
                            icon: 'error',
                            title: 'کد وارد شده معتبر نمی باشد'
                        })
                    }
                    if(err.responseJSON.errors.code){
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'center',
                            showConfirmButton: false,
                            timer: 3000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.addEventListener('mouseenter', Swal.stopTimer)
                                toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        })

                        Toast.fire({
                            icon: 'error',
                            title: err.responseJSON.errors.code[0]
                        })

                        return false;
                    }
                }
            });
        });
    </script>

@endsection
