@extends('Front.Layouts.app')
@section('meta')
    <meta name="keywords" content="{{ $aboutUs->seo_keywords ?? '' }}" />
    <meta name="description" content="{{ $aboutUs->seo_description ?? '' }}" />
    <meta property="og:title" content="{{ $aboutUs->seo_title ?? '' }}" />
    <meta property="og:description" content="{{ $aboutUs->seo_description ?? '' }}" />
    <meta property="og:type" content="website" />
    <meta property="og:locale" content="fa_IR" />
    <meta property="og:image" content="{{ asset($setting->header_logo ?? '') }}" />
    <meta name="twitter:title" content="{{ $aboutUs->seo_title ?? '' }}"/>
    <meta name="twitter:description" content="{{ $aboutUs->seo_description ?? '' }}" />
    <meta name="twitter:image" content="{{ asset($setting->header_logo ?? '') }}" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="@parhoonsazeh" />
    <meta name="twitter:creator" content="@parhoonsazeh" />
    <meta property="og:url" content="{{ route('front.aboutUsPage.index') }}">
    <link rel="canonical" href="{{ route('front.aboutUsPage.index') }}" />
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="theme-color" content="#252525">
    <link rel="shortcut icon" href="{{ asset($setting->header_logo ?? '') }}" type=image/x-icon>
    <meta name="robots" content="index,follow" />
@endsection
@section('title', __('labels.about_us'))
@section('head') @endsection
@section('style')
    <style>
        .meet-the-owners-left {
            left: auto !important;
            right: 0% !important;
        }
        .meet-the-owners-right {
            padding: 90px 245px 90px 55px !important;
        }
        .shop-local-container{
            direction: rtl;
        }

        @media only screen and (max-width: 600px) {
            .meet-the-owners-right {
                padding: 10px !important;
            }
        }
        /*.customer {
            padding-bottom: 7rem;
        }*/
    </style>
@endsection
@section('body')
    <link rel="stylesheet" href="{{asset('FrontTmpAssets/css/about.css')}}"/>

    <section class="container-fluid py-3"></section>
    <section class=" customer">
        <div class="col-12 wow fadeInUp ">
            @if($aboutUs->slideshow_status)
                <div class="hero-section about-hero"
                     style="background-image: -webkit-gradient(linear, left bottom, left top, from(#222), to(rgba(34, 34, 34, 0))), url('{{asset($aboutUs->slideshow_image ?? '')}}');">
                    <div class="p_container">
                        <div class="hero-wrapper">
                            <h1 class="hero-heading anout-hero-heading">
                                {{ $aboutUs->slideshow_title ?? '' }}
                            </h1>
                            <p class="hero-paragraph mb-3 mb-md-5">
                                {{ $aboutUs->slideshow_text ?? '' }}
                            </p>
                            <div class="hero-button-wrapper">
                                @if(!empty($aboutUs->slideshow_button_title))
                                    <a href="{{$aboutUs->slideshow_button_link ?? ''}}" class="p_btn light outline w-button">
                                        {{ $aboutUs->slideshow_button_title ?? '' }}
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <div class="content-section why-acme-sections wf-section">
                <div class="p_container">
                    <div class="about-top-block">
                        <div class="why-acme-block">
                            {!! $aboutUs->body ?? '' !!}
                        </div>
                    </div>
                </div>
            </div>

            @if(!empty($aboutUs->body_items))
                @if(!empty(json_decode($aboutUs->body_items)))
                    <div class="content-section wf-section">
                        <div class="p_container">
                            <div class="about-columns-wrapper">
                                @php
                                    $bodyItems = json_decode($aboutUs->body_items);
                                    $bodyItems = collect($bodyItems)->sortBy('sort_order');
                                @endphp
                                @if(!empty($bodyItems))
                                    @if(count($bodyItems))
                                        @foreach($bodyItems as $bodyItem)
                                            <div class="about-column">
                                                <img src="{{asset($bodyItem->image ?? '')}}" alt="Warranty Icon"
                                                     class="p_image">
                                                <h3>
                                                    {{ $bodyItem->title ?? '' }}
                                                </h3>
                                                <p>
                                                    {{ $bodyItem->text ?? '' }}
                                                </p>
                                            </div>
                                        @endforeach
                                    @endif
                                @endif
                            </div>
                        </div>
                    </div>
                @endif
            @endif

            @if($aboutUs->bottom_body_status == true)
                <div class="content-section wf-section">
                    <div class="p_container shop-local-container">
                        <div class="content-wrapper">
                            <div class="meet-the-owners-wrapper">
                                <div class="meet-the-owners-left"
                                     style="background-image: url('{{asset($aboutUs->bottom_body_image ?? '')}}');"></div>
                                <div class="meet-the-owners-right">
                                    <div class="owners-rich-text w-richtext">
                                        <h2>
                                            {{ $aboutUs->bottom_body_title ?? '' }}
                                        </h2>
                                        <p>
                                        @if(!empty($aboutUs->bottom_body_text))
                                            @foreach(explode("\n", $aboutUs->bottom_body_text ?? '') as $bottom_body_textLine)
                                                <p>
                                                    {{ $bottom_body_textLine ?? '' }}
                                                </p><br/>
                                                @endforeach
                                                @endif
                                                </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @if(!empty($aboutUs->persons))
                @if(!empty(json_decode($aboutUs->persons)))
                    <div class="content-section wf-section">
                        <div class="p_container">
                            <div class="owner-bios-wrapper">
                                @php
                                    $persons = json_decode($aboutUs->persons);
                                    $persons = collect($persons)->sortBy('sort_order');
                                @endphp
                                @if(!empty($persons))
                                    @if(count($persons))
                                        @foreach($persons as $person)
                                            <div class="owner-bio">
                                                <div class="owner-avatar-wrapper">
                                                    <img src="{{asset($person->image ?? '')}}" alt="{{$person->title ?? ''}}">
                                                </div>
                                                <h3>
                                                    {{ $person->title ?? '' }}
                                                </h3>
                                                <p class="owner-bio-paragraph">
                                                    {{ $person->text ?? '' }}
                                                </p>
                                            </div>
                                        @endforeach
                                    @endif
                                @endif
                            </div>
                        </div>
                    </div>
                @endif
            @endif

            @if($aboutUs->bottom_slideshow_status == true)
                <div class="hero-section contact-hero wf-section"
                     style="    background-image: -webkit-gradient(linear, left bottom, left top, from(#222), to(rgba(34, 34, 34, 0))), url('{{asset($aboutUs->bottom_slideshow_image ?? '')}}');">
                    <div class="p_container">
                        <div class="hero-wrapper">
                            <h1 class="hero-heading anout-hero-heading">
                                {{ $aboutUs->bottom_slideshow_title ?? '' }}
                            </h1>
                            <p class="hero-paragraph mb-3 mb-md-5">
                                {{ $aboutUs->bottom_slideshow_text ?? '' }}
                            </p>
                            <div class="hero-button-wrapper">
                                @if(!empty($aboutUs->bottom_slideshow_button_title))
                                    <a href="{{$aboutUs->bottom_slideshow_button_link ?? ''}}"
                                       class="p_btn light outline w-button">
                                        {{ $aboutUs->bottom_slideshow_button_title ?? '' }}
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>

    </section>


@endsection
@section('script_whole') @endsection
