@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'اسلایدشو')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                اسلایدشو
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">
<button class="btn btn-primary" type="submit" form="frm"><i class="fa fa-save"></i></button>
<a class="btn btn-default" href="{{route('admin.slideshow.index')}}"><i class="fa fa-reply"></i></a>
                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">

<form id="frm" action="{{ route('admin.slideshow.store') }}" method="post" enctype="multipart/form-data">
    @csrf

    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            ترتیب نمایش
        </label>
        <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order') }}">
        <label class="err_labels">{{$errors->first('sort_order')}}</label>
    </div>
    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            وضعیت
        </label>
        <select name="status" class="form-control">
            <option value="">
                انتخاب کنید
            </option>
            <option value="0" @if(old('status')!=null) @if(old('status')=='0') selected @endif @endif>
                غیرفعال
            </option>
            <option value="1" @if(old('status')!=null) @if(old('status')=='1') selected @endif @endif>
                فعال
            </option>
        </select>
        <label class="err_labels">{{$errors->first('status')}}</label>
    </div>

    <div class="form-group col-md-12 col-lg-12">
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                تصویر برای دسکتاپ
            </label>
            <label class="err_labels">{{$errors->first('image_desktop')}}</label>
            <input type="file" name="image_desktop" class="form-control imager">
        </div>
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                پیش نمایش
            </label>
            <div class="image_result">
                <img src="{{asset('images/no_pic.png')}}" style="max-width: 100%;">
            </div>
        </div>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                تصویر برای موبایل
            </label>
            <label class="err_labels">{{$errors->first('image_mobile')}}</label>
            <input type="file" name="image_mobile" class="form-control imager2">
        </div>
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                پیش نمایش
            </label>
            <div class="image_result2">
                <img src="{{asset('images/no_pic.png')}}" style="max-width: 100%;">
            </div>
        </div>
    </div>

    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            عنوان اول
            (اختیاری)
        </label>
        <input type="text" name="title_one" class="form-control" value="{{ old('title_one') }}">
        <label class="err_labels">{{$errors->first('title_one')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            عنوان دوم
            (اختیاری)
        </label>
        <input type="text" name="title_two" class="form-control" value="{{ old('title_two') }}">
        <label class="err_labels">{{$errors->first('title_two')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            عنوان سوم
            (اختیاری)
        </label>
        <input type="text" name="title_three" class="form-control" value="{{ old('title_three') }}">
        <label class="err_labels">{{$errors->first('title_three')}}</label>
    </div>

    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            متن
            (اختیاری)
        </label>
        <textarea class="form-control" name="text" rows="3">{{old('text')}}</textarea>
        <label class="err_labels">{{$errors->first('text')}}</label>
    </div>

    <div class="form-group col-md-4 col-lg-4">
        <label class="control-label">
            وضعیت نمایش دکمه
        </label>
        <select class="form-control" name="button_status">
            <option value="1">
                فعال
            </option>
            <option value="0">
                غیرفعال
            </option>
        </select>
        <label class="err_labels">{{$errors->first('button_status')}}</label>
    </div>
    <div class="form-group col-md-4 col-lg-4">
        <label class="control-label">
            عنوان دکمه
        </label>
        <input type="text" class="form-control" name="button_title" value="{{ old('button_title') }}">
        <label class="err_labels">{{$errors->first('button_title')}}</label>
    </div>
    <div class="form-group col-md-4 col-lg-4">
        <label class="control-label">
            لینک دکمه
        </label>
        <input type="text" class="form-control" name="button_link" value="{{ old('button_link') }}">
        <label class="err_labels">{{$errors->first('button_link')}}</label>
    </div>

</form>

                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')

    {{--Image--}}
    <script>
        /*** namayesh e tasvire entekhab shode bedoone upload ***/
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $(".image_result").html('');
                    $(".image_result").append('<img id="selected_photos" src="'+e.target.result+'" alt="your image" style="max-width: 100%;"/>');
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        $(document).on("change", ".imager", function(){readURL(this);});

        function readURL2(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $(".image_result2").html('');
                    $(".image_result2").append('<img id="selected_photos" src="'+e.target.result+'" alt="your image" style="max-width: 100%;"/>');
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        $(document).on("change", ".imager2", function(){readURL2(this);});
    </script>

@endsection
