@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'تنظیمات')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                تنظیمات
                -
                {{ $item->label }}
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">
<button class="btn btn-primary" type="submit" form="frm"><i class="fa fa-save"></i></button>
<a class="btn btn-default" href="{{route('admin.setting.index')}}"><i class="fa fa-reply"></i></a>
                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">

<form id="frm" action="{{ route('admin.setting.update', $item->id) }}" method="post" enctype="multipart/form-data">
    @csrf

    @if($item->type == 'text')
        <div class="form-group col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12">
            <label class="control-label">
                {{ $item->label }}
            </label>
            <textarea class="form-control" name="value" rows="5">{{ $item->value ?? '' }}</textarea>
            <label class="err_labels">
                {{ $errors->first('value') }}
            </label>
        </div>
    @elseif($item->type == 'image')
        <div class="form-group col-lg-6 col-md-6 col-sm-6 col-xs-12 col-12">
            <label class="control-label">
                {{ $item->label }}
            </label>
            <input type="file" class="form-control" name="value">
            <label class="err_labels">
                {{ $errors->first('value') }}
            </label>
        </div>
        <div class="form-group col-lg-6 col-md-6 col-sm-6 col-xs-12 col-12">
            <label class="control-label">
                تصویر فعلی
            </label><br/>
            <img src="{{ asset($item->value ?? 'images/no_pic.png') }}" style="max-width: 100%;">
        </div>
    @elseif($item->type == 'footerSocialIcons')
        <div class="form-group col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12">
            <label class="control-label">
                آیتم ها
            </label>
            <table id="tbl-footerSocialIcons" class="table table-condensed table-striped table-hover">
                <thead>
                    <th>
                        تصویر
                    </th>
                    <th>
                        لینک
                    </th>
                    <th>
                        حذف
                    </th>
                </thead>
                <tbody>
                    @if(!empty($item->value))
                        @if(!empty(json_decode($item->value)))
                            @foreach(json_decode($item->value) as $valItem)
                                <tr>
                                    <td>
                                        <input type="hidden" class="form-control" name="icons_old[]" value="{{ $valItem->icon ?? '' }}">
                                        <img src="{{ asset($valItem->icon ?? '') }}" style="max-width: 200px;">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="links[]" value="{{ $valItem->link ?? '' }}">
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-danger form-control btn-remove">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        @endif
                    @endif
                    <tr>
                        <td>
                            <input type="file" class="form-control" name="icons_new[]">
                        </td>
                        <td>
                            <input type="text" class="form-control" name="links[]">
                        </td>
                        <td>
                            <button type="button" class="btn btn-danger form-control btn-remove">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td></td>
                        <td>
                            <button type="button" class="btn btn-primary form-control btn-add">
                                <i class="fa fa-plus-circle"></i>
                            </button>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endif

</form>

                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')

    <script>
        $(".btn-add").on("click", function(){
            var html = '';
            html += '<tr>';

            html += '<td>';
            html += '<input type="file" class="form-control" name="icons_new[]">';
            html += '</td>';

            html += '<td>';
            html += '<input type="text" class="form-control" name="links[]">';
            html += '</td>';

            html += '<td>';
            html += '<button type="button" class="btn btn-danger form-control btn-remove">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '</td>';

            html += '</tr>';

            $("#tbl-footerSocialIcons").find('tbody').append(html);
        });
        $(document).on("click", ".btn-remove", function(){
            $(this).closest('tr').remove();
        });
    </script>

@endsection
