@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'صفحات سایت')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                صفحات سایت
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">



<a class="btn btn-primary" href="{{route('admin.page.page.create')}}"><i class="fa fa-plus"></i></a>
<a class="btn btn-default" href="{{route('admin.page.page.index')}}"><i class="fa fa-refresh"></i></a>
                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">
<table id="table_datatable" class="table table-condensed table-hover table-striped">
    <thead>
    <tr>
        <td>#</td>
        <td>عنوان</td>
        <td>دسترسی</td>
        <td>وضعیت</td>
        <td>تعداد بازدید</td>
        <td class="element-hideFromPrint">عملیات</td>
    </tr>
    </thead>
    <tbody>
        @if(!empty($pages))
            @foreach($pages as $key=>$page)
                <tr>
                    <td>{{$key+1}}</td>
                    <td>
                        {{$page->title}}
                    </td>
                    <td>
                        <a href="{{route('front.page.show', $page->slug)}}" class="btn btn-primary" target="_blank">
                            کلیک کنید
                        </a>
                    </td>
                    <td>
                        @if($page->status)
                            <label style="color: darkgreen;">
                                <i class="fa fa-check-circle"></i>
                                فعال
                            </label>
                        @else
                            <label style="color: darkred;">
                                <i class="fa fa-times-circle"></i>
                                غیرفعال
                            </label>
                        @endif
                    </td>
                    <td>
                        {{number_format($page->visit_count ?? 0)}}
                    </td>
                    <td class="element-hideFromPrint">
                        <form action="{{route('admin.page.page.destroy', $page->id)}}" method="post">
                            {{csrf_field()}}
                            {{method_field("DELETE")}}

                            <a href="{{route('admin.page.page.edit', $page->id)}}" class="btn btn-warning">
                                <i class="fa fa-pencil"></i>
                            </a>

                            <button type="button" class="btn btn-danger destroy">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            @endforeach
        @endif
    </tbody>
</table>
                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')

    {{--Close message--}}
    <script>
        setTimeout(function(){
            $("#page-wrapper").find('.session_message_label').slideUp("slow");
        }, 5000);
    </script>
    {{--end of Close message--}}

    {{--delete --}}
    <script>
        $(document).on("click", ".destroy", function(e){
            e.preventDefault();
            var form = $(this).closest('form');
            swal.fire({
                title: "اطمینان دارید؟",
                text: "پس از حذف قابل بازیابی نمی باشد",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "بله, حذف شود",
                cancelButtonText: "خیر"
            }).then((result) => {
                if (result.value) {
                    form.trigger("submit");
                }
            });
        });
    </script>
    {{--end of delete --}}

@endsection
