@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'صفحات سایت')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                صفحات سایت
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">
                            <button type="submit" form="frm" class="btn btn-primary"><i class="fa fa-save"></i></button>
                            <a class="btn btn-default" href="{{route('admin.page.page.index')}}"><i class="fa fa-reply"></i></a>
                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">
<form action="{{route('admin.page.page.update', $page->id)}}" method="post" id="frm" enctype="multipart/form-data">
    {{csrf_field()}}
    {{method_field("PATCH")}}
    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            عنوان
        </label>
        <input type="text" class="form-control" name="title" id="title" value="{{old('title', $page->title)}}">
        <label class="err_labels">{{$errors->first('title')}}</label>
    </div>
    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            نام دسترسی
        </label>
        <input type="text" class="form-control" name="slug" id="slug" value="{{old('slug', $page->slug ?? '')}}" placeholder="">
        <label class="err_labels">{{$errors->first('slug')}}</label>
    </div>
    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            وضعیت
        </label>
        <select name="status" class="form-control">
            <option value="">
                انتخاب کنید
            </option>
            <option value="0" @if($page->status == 0) selected @endif>
                غیرفعال
            </option>
            <option value="1" @if($page->status == 1) selected @endif>
                فعال
            </option>
        </select>
        <label class="err_labels">{{$errors->first('status')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            محتوا
        </label>
        <textarea name="content" id="ck_editor" class="form-control editor">{{old('content', $page->content)}}</textarea>
        <label class="err_labels">{{$errors->first('content')}}</label>
    </div>


{{--SEO--}}
    <div class="form-group col-md-12 col-lg-12">
        <hr/>
        <label class="control-label" style="padding-right: 10px;">Seo</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            {{ __('labels.seo_title') }}
        </label>
        <input type="text" class="form-control" name="seo_title" value="{{$page->seo_title}}">
        <label class="err_labels">{{$errors->first('seo_title')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            {{ __('labels.seo_description') }}
        </label>
        <textarea name="seo_description" class="form-control" placeholder="">{{$page->seo_description}}</textarea>
        <label class="err_labels">{{$errors->first('seo_description')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            {{ __('labels.seo_keywords') }}
        </label>
        <textarea name="seo_keywords" class="form-control" placeholder="{{ __('labels.seo_tag_example') }}">{{$page->seo_keywords}}</textarea>
        <label style="color: blue;font-weight: bold; font-size: 12px;">
            <i class="fa fa-info-circle"></i>
            {{ __('labels.seo_tag_desc') }}
        </label>
        <label class="err_labels">{{$errors->first('seo_keywords')}}</label>
    </div>

</form>
                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')


    <script>
        $("#remove_header").on("change", function(){
            if($(this).is(':checked')){
                $("#div-header_fields").css('display', 'none');
                $(this).closest('label').find('span').text("{{__('labels.add')}} {{__('labels.header')}}");
                $(this).closest('label').removeClass('btn-danger');
                $(this).closest('label').addClass('btn-primary');
            }
            else{
                $("#div-header_fields").css('display', 'block');
                $(this).closest('label').find('span').text("{{ __('labels.remove') }} {{ __('labels.header') }}");
                $(this).closest('label').removeClass('btn-primary');
                $(this).closest('label').addClass('btn-danger');
            }
        });
    </script>


@endsection
