@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'منو ها')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                آیتم ها
                '{{ $menu->title ?? '' }}'
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">
<a class="btn btn-primary" href="{{route('admin.menu.item.create', ['menu_id'=>$menu->id])}}"><i class="fa fa-plus"></i></a>
<a class="btn btn-default" href="{{route('admin.menu.item.index', ['menu_id'=>$menu->id])}}"><i class="fa fa-refresh"></i></a>
<a class="btn btn-info" href="{{route('admin.menu.index')}}"><i class="fa fa-reply"></i></a>
                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">
<table id="table_datatable" class="table table-condensed table-hover table-striped">
    <thead>
        <th>#</th>
        <th>ترتیب نمایش</th>
        <th>عنوان</th>
        <th>وضعیت</th>
        @if($menu->position == 'menu-top')
            <th>والد</th>
            <th>فرزندان</th>
        @endif
        <th>عملیات</th>
    </thead>
    <tbody>
    @if(!empty($items))
        @foreach($items as $key=>$item)
            <tr>
                <td>{{$key+1}}</td>
                <td>
                    {{ $item->sort_order }}
                </td>
                <td>
                    {{ $item->title }}
                </td>
                <td>
                    @if($item->status)
                        <label style="color: darkgreen;">
                            <i class="fa fa-check-circle"></i>
                            فعال
                        </label>
                    @else
                        <label style="color: darkred;">
                            <i class="fa fa-times-circle"></i>
                            غیرفعال
                        </label>
                    @endif
                </td>
                @if($menu->position == 'menu-top')
                    <td>
                        @if(!empty($item->parent))
                            <label style="color: darkblue;">
                                {{ $item->parent->title ?? '' }}
                            </label>
                        @else
                            <label style="color: brown;">
                                بدون والد
                            </label>
                        @endif
                    </td>
                    <td>
                        @if(count($item->children))
                            <label style="color: darkblue;">
                                @foreach($item->children as $key=>$child)
                                    {{ $key+1 }}-
                                    {{ $child->title ?? '' }}
                                    <br/>
                                @endforeach
                            </label>
                        @else
                            <label style="color: brown;">
                                بدون فرزند
                            </label>
                        @endif
                    </td>
                @endif
                <td>
                    <a href="{{route('admin.menu.item.edit',$item->id)}}" class="btn btn-warning">
                        <i class="fa fa-pencil"></i>
                    </a>
                    <a href="{{route('admin.menu.item.delete', $item->id)}}" class="btn btn-danger destroy">
                        <i class="fa fa-trash"></i>
                    </a>
                </td>
            </tr>
        @endforeach
    @endif
    </tbody>
</table>
                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')

    {{--delete --}}
    <script>
        $(document).on("click", ".destroy", function(e){
            e.preventDefault();
            var url = $(this).attr('href');
            swal.fire({
                title: "اطمینان دارید؟",
                text: "پس از حذف قابل بازیابی نمی باشد",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "بله, حذف شود",
                cancelButtonText: "خیر"
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>
    {{--end of delete --}}

@endsection
