@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'منو ها')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                آیتم ها
                '{{ $item->menu->title ?? '' }}'
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">
<button class="btn btn-primary" type="submit" form="frm"><i class="fa fa-save"></i></button>
<a class="btn btn-default" href="{{route('admin.menu.item.index', ['menu_id'=>$item->menu_id])}}"><i class="fa fa-reply"></i></a>
                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">

<form id="frm" action="{{ route('admin.menu.item.update', $item->id) }}" method="post">
    @csrf

    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            ترتیب نمایش
        </label>
        <input name="sort_order" type="number" class="form-control" value="{{ old('sort_order', $item->sort_order) }}">
        <label class="err_labels">{{$errors->first('sort_order')}}</label>
    </div>
    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            وضعیت
        </label>
        <select name="status" class="form-control">
            <option value="">
                انتخاب کنید
            </option>
            <option value="0" @if(old('status', $item->status)=='0') selected @endif>
                غیرفعال
            </option>
            <option value="1" @if(old('status', $item->status)=='1') selected @endif>
                فعال
            </option>
        </select>
        <label class="err_labels">{{$errors->first('status')}}</label>
    </div>

    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            عنوان
        </label>
        <input type="text" name="title" class="form-control" value="{{ old('title', $item->title ?? '') }}">
        <label class="err_labels">{{$errors->first('title')}}</label>
    </div>

    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            لینک
        </label>
        <input type="text" name="link" class="form-control" value="{{ old('link', $item->link ?? '') }}">
        <label class="err_labels">{{$errors->first('link')}}</label>
    </div>

    @if($item->menu->position == 'menu-top')
        <div class="form-group col-md-12 col-lg-12">
            <label class="control-label">
                والد
            </label>
            <select name="parent_id" class="form-control">
                <option value="">
                    بدون والد
                </option>
                @if(!empty($parents))
                    @if(count($parents))
                        @foreach($parents as $parent)
                            <option value="{{ $parent->id }}" @if($item->parent_id == $parent->id) selected @endif>
                                {{ $parent->title ?? '' }}
                            </option>
                        @endforeach
                    @endif
                @endif
            </select>
            <label class="err_labels">{{$errors->first('parent_id')}}</label>
        </div>
    @endif

</form>

                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')


@endsection
