@extends('Admin.Layouts.app')
@section('body')
    <header class="main-header"><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <!-- Logo -->
        <a href="{{url('/')}}" class="logo">
            <!-- mini logo for sidebar mini 50x50 pixels -->
            <span class="logo-mini"><b> </b></span>
            <!-- logo for regular state and mobile devices -->
            <span class="logo-lg"><b></b></span>

            <img src="{{asset(settings('header_logo'))}}" style="height: 80%;width: 100%;object-fit: contain;margin: 0 auto;">
        </a>
        <!-- Header Navbar: style can be found in header.less -->
        <nav class="navbar navbar-static-top" role="navigation">
            <!-- Sidebar toggle button-->
            <a href="#" id="open_hide_dasti" class="open_hide_dasti" {{--data-toggle="offcanvas" role="button"--}}>
                <i class="fa fa-bars" id="open_hide_dasti_i" style="color: white;"></i>
            </a>
            <div class="navbar-custom-menu">
                <ul class="nav navbar-nav">
                    <!-- User Account: style can be found in dropdown.less -->
                    <li class="dropdown user user-menu">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                            <img src="{{asset('admin_panel_assets/dist/img/user2-160x160.jpg')}}" class="user-image" alt="User Image">
                            <span class="hidden-xs"></span>
                        </a>
                        <ul class="dropdown-menu">
                            <!-- User image -->
                            <li class="user-header">
                                <img src="{{asset('admin_panel_assets/dist/img/user2-160x160.jpg')}}" class="img-circle" alt="User Image">
                                <p>
                                    {{\Auth::guard('admin')->user()->email}}
                                    <br/>
                                    {{\Auth::guard('admin')->user()->mobile_number}}
                                </p>
                            </li>
                            <!-- Menu Footer-->
                            <li class="user-footer">
                                <div class="pull-left">
                                    <a href="{{route('admin.logout')}}" class="btn btn-default btn-flat">
                                        خروج
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </li>
                    <!-- Control Sidebar Toggle Button -->
                </ul>
            </div>
        </nav>
    </header>


    <div class="AdminSessionMessage">
        @include('Admin.Layouts.sessionMessage')
    </div>


    <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar" id="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <section class="sidebar">
            <!-- Sidebar user panel -->
            <div class="user-panel">
                <div class="pull-right image">
                    <img src="{{asset('admin_panel_assets/dist/img/user2-160x160.jpg')}}" class="img-circle" alt="User Image">
                </div>
                <div class="pull-left info">
                    <p style="overflow: hidden;">
                        {{\Auth::guard('admin')->user()->email}}
                    </p>
                    <a href="#"><i class="fa fa-circle text-success"></i>
                        آنلاین
                    </a>
                </div>
            </div>
            <ul class="sidebar-menu">
                <li class="treeview @if($current_route_name == 'admin.panel') active @endif">
                    <a href="{{route('admin.panel')}}">
                        <i class="fa fa-dashboard"></i> <span>
                            داشبورد
                        </span>
                    </a>
                </li>

                <li class="treeview @if($current_route_name == 'admin.my_info') active @endif">
                    <a href="{{route('admin.my_info')}}">
                        <i class="fa fa-user"></i> <span>
                            اطلاعات من
                        </span>
                    </a>
                </li>

                @if(AdminPermissionHelper_check('admins'))
                    <li class="treeview @if(strstr($current_route_name, 'admin.admins')) active @endif">
                        <a href="{{route('admin.admins.list')}}">
                            <i class="fa fa-slideshare"></i>
                            <span>
                                مدیران
                            </span>
                        </a>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('menus'))
                    <li class="treeview @if(strstr($current_route_name, 'menu')) active @endif">
                        <a href="{{route('admin.menu.index')}}">
                            <i class="fa fa-list-ul"></i>
                            منو ها
                        </a>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('slideshows'))
                    <li class="treeview @if(strstr($current_route_name, 'slideshow')) active @endif">
                        <a href="{{route('admin.slideshow.index')}}">
                            <i class="fa fa-image"></i>
                            اسلایدشو
                        </a>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('faqs'))
                    <li class="treeview @if(strstr($current_route_name, 'faq')) active @endif">
                        <a href="{{route('admin.faq.index')}}">
                            <i class="fa fa-question-circle"></i>
                            سوالات متداول
                        </a>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('blog'))
                    <li class="treeview @if(strstr($current_route_name, 'blog')) active @endif">
                        <a href="#">
                            <i class="fa fa-copy"></i>
                            <span>
                                بلاگ
                            </span>
                            <i class="fa fa-angle-left pull-left"></i>
                        </a>
                        <ul class="treeview-menu">
                            <li class="treeview @if(strstr($current_route_name, 'blog.category')) active @endif">
                                <a href="{{route('admin.blog.category.index')}}">
                                    <i class="fa"></i>
                                    دسته بندی
                                </a>
                            </li>
                            <li class="treeview @if(strstr($current_route_name, 'blog.article')) active @endif">
                                <a href="{{ route('admin.blog.article.index') }}">
                                    <i class="fa"></i>
                                    مقالات
                                </a>
                            </li>
                        </ul>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('firstPageChallenge'))
                    <li class="treeview @if(strstr($current_route_name, 'firstPageChallenge')) active @endif">
                        <a href="#">
                            <i class="fa fa-copy"></i>
                            <span>
                                چالش های صفحه اصلی
                            </span>
                            <i class="fa fa-angle-left pull-left"></i>
                        </a>
                        <ul class="treeview-menu">
                            <li class="treeview @if(strstr($current_route_name, 'firstPageChallenge.desc.index')) active @endif">
                                <a href="{{route('admin.firstPageChallenge.desc.index')}}">
                                    <i class="fa"></i>
                                    توضیحات
                                </a>
                            </li>
                            <li class="treeview @if(strstr($current_route_name, 'firstPageChallenge.item')) active @endif">
                                <a href="{{ route('admin.firstPageChallenge.item.index') }}">
                                    <i class="fa"></i>
                                    آیتم ها
                                </a>
                            </li>
                        </ul>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('firstPageStep'))
                    <li class="treeview @if(strstr($current_route_name, 'firstPageStep')) active @endif">
                        <a href="{{route('admin.firstPageStep.index')}}">
                            <i class="fa fa-square-o"></i>
                            مرحله های صفحه اصلی
                        </a>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('firstPageReceiveCapital'))
                    <li class="treeview @if(strstr($current_route_name, 'firstPageReceiveCapital')) active @endif">
                        <a href="#">
                            <i class="fa fa-square"></i>
                            <span>
                                دریافت سرمایه در صفحه اصلی
                            </span>
                            <i class="fa fa-angle-left pull-left"></i>
                        </a>
                        <ul class="treeview-menu">
                            <li class="treeview @if(strstr($current_route_name, 'firstPageReceiveCapital.desc.index')) active @endif">
                                <a href="{{route('admin.firstPageReceiveCapital.desc.index')}}">
                                    <i class="fa"></i>
                                    توضیحات
                                </a>
                            </li>
                            <li class="treeview @if(strstr($current_route_name, 'firstPageChallenge.item')) active @endif">
                                <a href="{{ route('admin.firstPageReceiveCapital.item.index') }}">
                                    <i class="fa"></i>
                                    آیتم ها
                                </a>
                            </li>
                        </ul>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('firstPageBestChallenge'))
                    <li class="treeview @if(strstr($current_route_name, 'firstPageBestChallenges')) active @endif">
                        <a href="#">
                            <i class="fa fa-circle-o"></i>
                            <span>
                                بهترین چالش های صفحه اصلی
                            </span>
                            <i class="fa fa-angle-left pull-left"></i>
                        </a>
                        <ul class="treeview-menu">
                            <li class="treeview @if(strstr($current_route_name, 'firstPageBestChallenges.desc.index')) active @endif">
                                <a href="{{route('admin.firstPageBestChallenges.desc.index')}}">
                                    <i class="fa"></i>
                                    توضیحات
                                </a>
                            </li>
                            <li class="treeview @if(strstr($current_route_name, 'firstPageBestChallenges.item')) active @endif">
                                <a href="{{ route('admin.firstPageBestChallenges.item.index') }}">
                                    <i class="fa"></i>
                                    آیتم ها
                                </a>
                            </li>
                        </ul>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('firstPageGuide'))
                    <li class="treeview @if(strstr($current_route_name, 'firstPageGuide')) active @endif">
                        <a href="#">
                            <i class="fa fa-circle"></i>
                            <span>
                                راهنما صفحه اصلی
                            </span>
                            <i class="fa fa-angle-left pull-left"></i>
                        </a>
                        <ul class="treeview-menu">
                            <li class="treeview @if(strstr($current_route_name, 'firstPageGuide.desc.index')) active @endif">
                                <a href="{{route('admin.firstPageGuide.desc.index')}}">
                                    <i class="fa"></i>
                                    توضیحات
                                </a>
                            </li>
                            {{--<li class="treeview @if(strstr($current_route_name, 'firstPageGuide.item')) active @endif">
                                <a href="{{ route('admin.firstPageGuide.item.index') }}">
                                    <i class="fa"></i>
                                    آیتم ها
                                </a>
                            </li>--}}
                        </ul>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('pages'))
                    <li class="treeview @if(strstr($current_route_name, "page.page")) active @endif">
                        <a href="{{route('admin.page.page.index')}}">
                            <i class="fa fa-copy"></i>
                            صفحات سایت
                        </a>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('about_us'))
                    <li class="treeview @if(strstr($current_route_name, "aboutUsPage")) active @endif">
                        <a href="{{route('admin.aboutUsPage.index')}}">
                            <i class="fa fa-info-circle"></i>
                            صفحه درباره ما
                        </a>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('contact_us'))
                    <li class="treeview @if(strstr($current_route_name, "contactUsPage")) active @endif">
                        <a href="#">
                            <i class="fa fa-indent"></i>
                            <span>
                                صفحه تماس با ما
                            </span>
                            <i class="fa fa-angle-left pull-left"></i>
                        </a>
                        <ul class="treeview-menu">
                            <li class="treeview @if(strstr($current_route_name, "contactUsPage.desc")) active @endif">
                                <a href="{{route('admin.contactUsPage.desc.index')}}">
                                    <i class="fa"></i>
                                    تنظیمات صفحه
                                </a>
                            </li>
                            <li class="treeview @if(strstr($current_route_name, "contactUsPage.message")) active @endif">
                                <a href="{{route('admin.contactUsPage.message.index')}}">
                                    <i class="fa"></i>
                                    پیام ها
                                </a>
                            </li>
                        </ul>
                    </li>
                @endif

                @if(AdminPermissionHelper_check('setting'))
                    <hr/>
                    <li class="treeview @if(strstr($current_route_name, 'setting')) active @endif">
                        <a href="{{route('admin.setting.index')}}">
                            <i class="fa fa-gears"></i>
                            تنظیمات
                        </a>
                    </li>
                @endif

            </ul>
        </section>
        <!-- /.sidebar -->
    </aside>

    @yield('content')

    <footer class="main-footer">
        <div class="pull-left hidden-xs">
            {{--<b>Version</b> 2.2.0--}}
        </div>
        <strong>Copyright &copy;  <a target="_blank" {{--href="http://npco.net"--}}>NoNegar Pardazesh</a>.</strong> All rights reserved.
    </footer>
    @yield('footer')
@endsection
