<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <meta name="csrf-token" content="{{csrf_token()}}">
        @yield('metas')

        <!-- Bootstrap 3.3.4 -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/bootstrap/css/bootstrap.min.css')}}">
        <!-- not use this in ltr -->

        <!-- Theme style -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/dist/css/AdminLTE.min.css')}}">

        <!-- Font Awesome -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/css/font-awesome.min.css')}}">
        <!-- Ionicons 2.0.0 -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/css/ionicons.min.css')}}">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/dist/css/skins/_all-skins.min.css')}}">
        <!-- iCheck -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/plugins/iCheck/flat/blue.css')}}">
        <!-- Morris chart -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/plugins/morris/morris.css')}}">
        <!-- jvectormap -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/plugins/jvectormap/jquery-jvectormap-1.2.2.css')}}">
        <!-- Date Picker -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/plugins/datepicker/datepicker3.css')}}">
        <!-- Daterange picker -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/plugins/daterangepicker/daterangepicker-bs3.css')}}">
        <!-- bootstrap wysihtml5 - text editor -->
        <link rel="stylesheet" href="{{asset('admin_panel_assets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css')}}">

        <link rel="stylesheet" href="{{asset('admin_panel_assets/dist/fonts/fonts-fa.css')}}">
        <link rel="stylesheet" href="{{asset('admin_panel_assets/dist/css/bootstrap-rtl.min.css')}}">
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="{{asset('admin_panel_assets/js/html5shiv.min.js')}}"></script>
        <script src="{{asset('admin_panel_assets/js/respond.min.js')}}"></script>
        <![endif]-->

        {{--data table--}}
        <link href="{{asset('js/datatable/jquery.datatables.min.css')}}" rel="stylesheet">

        <script>
            setTimeout(function(){
                $(".AdminSessionMessage").fadeOut("slow");
            }, 5000);
        </script>

        {{--SlimSelect--}}
        <script src="{{asset('js/slimselect/slimselect.min.js')}}"></script>
        <link href="{{asset('js/slimselect/slimselect.min.css')}}" rel="stylesheet">

        @yield('head')


        <style>
            .AdminSessionMessage{
                position: absolute;
                top: 6%;
                right: 6%;
                left: unset;
                z-index: 999999999999999;
                min-width: 40%;
                text-align: right;
                direction: ltr;
            }
            .content-wrapper{
                min-height: 800px !important;
            }
            .main-sidebar{
                min-height: 850px !important;
            }

            .button_base_div{
                background-color: lightblue;
                padding: 10px;
                margin-bottom: 10px;
                border: 2px solid;
                border-radius: 10px;
            }

            .lbl-slug{
                text-align: right !important;
                direction: ltr !important;
                float: right !important;
                border-right: 0 !important;
                background: #d5d5d5 !important;
                height: 34px !important;
                padding: 6px 2px 6px 12px !important;
                font-size: 14px !important;
                line-height: 1.428571 !important;
            }
            .lang_dropDown{
                background: #367fa9 !important;
                font-weight: bold !important;
                color: white !important;
                text-align: center !important;
                border-right: 2px solid black !important;
                border-left: 2px solid black !important;
                border-bottom: 4px solid black !important;
            }
            .lang_dropDown li{
                cursor: pointer !important;
                transition: 0.5s !important;
            }
            .lang_dropDown li:hover{
                background: white !important;
                color: black !important;
                transition: 0.5s !important;
            }
            .lang_dropDown .active{
                color: darkgreen !important;
                background-color: #dceaef !important;
            }

            .message-area{
                width: 80%;
                margin: 0 auto;
            }

            /*slim-select*/
            .ss-value-delete{
                color: white;
                padding: 0px 8px;
                display: block !important;
                background: #ef5757;
                margin-right: 5px;
                margin-left: 0;
            }
            .ss-option{
                text-align: right;
            }
            .ss-search input{
                text-align: right !important;
            }

            /*New Loader*/
            .input-karnakon{
                background: lightgrey;
                pointer-events: none;
            }
            .new_waiter{
                text-align: center;
                width: 20%;
                background: lightgrey;
                position: fixed;
                height: 30%;
                right: 40%;
                top: 45%;
                z-index: 1000000699;
                border-radius: 10px;
                display: none;
            }
            .new_waiter>label{
                font-weight: bold;
                padding-top: 10%;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
                color: #ffd101;
                text-shadow: 0px 0px 4px black;
                width: 100%;
                text-align: center;
            }
            .splitter{
                height: 150px;
            }
            .emptyHeaderNotShowInMobile{
                height: 120px;
            }
            @media only screen and (max-width: 600px) {
                .emptyHeaderNotShowInMobile{
                    display: none !important;
                }
                .splitter{
                    display: none;
                }
                .new_waiter{
                    text-align: center;
                    width: 90%;
                    background: lightgrey;
                    position: fixed;
                    height: 30%;
                    right: 5%;
                    top: 45%;
                    z-index: 1000000699;
                    border-radius: 10px;
                    display: none;
                }
                .new_waiter>label{
                    font-weight: bold;
                    color: grey;
                    padding-top: 10%;
                    white-space: nowrap;
                    overflow: hidden;
                    text-overflow: ellipsis;
                }
                .AdminSessionMessage{
                    min-width: 75%;
                }
            }
            .waiting-contain{
                /*padding-left: 34%;
                padding-top: 15%;*/
            }
            .loading7 {
                position: relative;
                border: 5px double #172d5a;
                width: 50px;
                height: 50px;
                margin: 10px auto;
                border-radius: 50%;
                box-sizing: initial;
                border-top-color: transparent;
                border-bottom-color: transparent;
                animation-name: loading3;
                animation-duration: 1200ms;
                animation-iteration-count: infinite;
                -webkit-animation-timing-function: linear;
            }
            .loading7:after {
                content: "";
                position: absolute;
                border: 5px double #172d5a;
                border-top-color: transparent;
                border-bottom-color: transparent;
                width: 36px;
                height: 36px;
                top: 2px;
                left: 2px;
                margin: auto;
                border-radius: 50%;
                box-sizing: initial;
                animation-name: loading7;
                animation-duration: 600ms;
                animation-iteration-count: infinite;
                -webkit-animation-timing-function: linear;
            }
            .loading7 .extra {
                position: relative;
                border: 5px double #0d1c3b;
                width: 25px;
                height: 25px;
                margin: 7px auto;
                border-radius: 50%;
                box-sizing: initial;
                border-top-color: transparent;
                border-bottom-color: transparent;
                animation-name: loading3;
                animation-duration: 1200ms;
                animation-iteration-count: infinite;
                -webkit-animation-timing-function: linear;
                display: flex;
                justify-content: center;
                align-items: center;
                align-content: center;
            }
            .loading7 .extra:after {
                content: "";
                position: relative;
                border: 5px double #172d5a;
                border-top-color: transparent;
                border-bottom-color: transparent;
                width: 20px;
                height: 20px;
                /* top: 2px; */
                /* left: 2px; */
                margin: auto;
                border-radius: 50%;
                box-sizing: border-box;
                animation-name: loading7;
                animation-duration: 300ms;
                animation-iteration-count: infinite;
                -webkit-animation-timing-function: linear;

            }
            @keyframes loading7 {
                0% {
                    transform: rotate(360deg);
                    -ms-transform: rotate(360deg);
                }
                100% {
                    transform: rotate(0deg);
                    -ms-transform: rotate(0deg);
                }
            }
            @-webkit-keyframes loading7 {
                0% {
                    transform: rotate(360deg);
                    -ms-transform: rotate(360deg);
                }
                100% {
                    transform: rotate(0deg);
                    -ms-transform: rotate(0deg);
                }
            }
            /*End Of New Loader*/

            .session_message_label{
                border: none;
                border-radius: 10px;
                text-align: center;
                background-color: skyblue;
                color: white;
                font-weight: bold;
            }

            /*Hide Arrows in number inputs*/
            /* Chrome, Safari, Edge, Opera */
            input::-webkit-outer-spin-button,
            input::-webkit-inner-spin-button {
                -webkit-appearance: none;
                margin: 0;
            }
            /* Firefox */
            input[type=number] {
                -moz-appearance: textfield;
            }
            /*End Of Hide Arrows in number inputs*/

            #morris-area-chart{
                min-height: 900px;
            }

            th{
                text-align: center;
                font-weight: bold;
                font-size: 14px;
            }
            td{
                text-align: center;
                font-weight: bold;
                font-size: 12px;
            }

            .err_labels{
                width: 100%;
                text-align: center;
                color: darkred;
                text-shadow: 0px 4px 4px red;
            }

            .open_hide_dasti{
                float: right;
                background-color: transparent;
                background-image: none;
                padding: 15px 15px;
                font-family: fontAwesome;
            }
            .open_hide_dasti{
                opacity: 0;
            }
            /* Extra small devices (phones, 600px and down) */
            @media only screen and (max-width: 600px) {
                .open_hide_dasti{
                    opacity: 1;
                }
                #morris-area-chart{
                    /*overflow-x: scroll;*/
                }
            }
            /*tables in mobi*/
            .box-body.chat{
                overflow-x: scroll;
            }

            .content-header *{
                color: black;
            }

            .connectedSortable{
                padding: 10px;
            }

            .box-body{
                min-height: 300px;
            }

            select{
                font-size: 80% !important;
                border-radius: 5px !important;
            }

            .session_message_label{
                border: none;
                background-color: #029fdf;
                color: white;
                text-align: center;
                font-weight: bold;
                border-radius: 10px;
            }

            .sidebar-menu li{
                white-space: initial;
            }
        </style>
        @yield('style')

    </head>
    <title>@yield('title')</title>

    <body class="skin-blue sidebar-mini sidebar-open">
        @yield('body')
        {{--New_waiter--}}
        <div class="new_waiter">
            <label class="waiter_title"></label>
            <br/>
            <div class="waiting-contain">
                <div class="loading7">
                    <div class="extra"></div>
                </div>
            </div>
        </div>

    </body>

    <footer>
        @yield('footer')
        <!-- jQuery 2.1.4 -->
        <script src="{{asset('admin_panel_assets/plugins/jQuery/jQuery-2.1.4.min.js')}}"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="{{asset('admin_panel_assets/js/jquery-ui.min.js')}}"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
            $.widget.bridge('uibutton', $.ui.button);
        </script>
        <!-- Bootstrap 3.3.4 -->
        <script src="{{asset('admin_panel_assets/bootstrap/js/bootstrap.min.js')}}"></script>
        <!-- Morris.js charts -->
        <script src="{{asset('admin_panel_assets/js/raphael-min.js')}}"></script>
        <script src="{{asset('admin_panel_assets/plugins/morris/morris.min.js')}}"></script>
        <!-- Sparkline -->
        <script src="{{asset('admin_panel_assets/plugins/sparkline/jquery.sparkline.min.js')}}"></script>
        <!-- jvectormap -->
        <script src="{{asset('admin_panel_assets/plugins/jvectormap/jquery-jvectormap-1.2.2.min.js')}}"></script>
        <script src="{{asset('admin_panel_assets/plugins/jvectormap/jquery-jvectormap-world-mill-en.js')}}"></script>
        <!-- jQuery Knob Chart -->
        <script src="{{asset('admin_panel_assets/plugins/knob/jquery.knob.js')}}"></script>
        <!-- daterangepicker -->
        <script src="{{asset('admin_panel_assets/js/moment.min.js')}}"></script>
        <script src="{{asset('admin_panel_assets/plugins/daterangepicker/daterangepicker.js')}}"></script>
        <!-- datepicker -->
        <script src="{{asset('admin_panel_assets/plugins/datepicker/bootstrap-datepicker.js')}}"></script>
        <!-- Bootstrap WYSIHTML5 -->
        <script src="{{asset('admin_panel_assets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js')}}"></script>
        <!-- Slimscroll -->
        <script src="{{asset('admin_panel_assets/plugins/slimScroll/jquery.slimscroll.min.js')}}"></script>
        <!-- FastClick -->
        <script src="{{asset('admin_panel_assets/plugins/fastclick/fastclick.min.js')}}"></script>
        <!-- AdminLTE App -->
        <script src="{{asset('admin_panel_assets/dist/js/app.min.js')}}"></script>
        <!-- AdminLTE dashboard demo (This is only for demo purposes) -->
        <script src="{{asset('admin_panel_assets/dist/js/pages/dashboard.js')}}"></script>
        <!-- AdminLTE for demo purposes -->
        <script src="{{asset('admin_panel_assets/dist/js/demo.js')}}"></script>

        {{--baz o baste shodane right menu e admin, custome shode, taghire name va id haye safhe header_slider.blade.php--}}
        <script>
            $('body').click(function(evt){
                if($(evt.target.closest("#main-sidebar")).length === 0){
                    /*yani rooye menu nistesh*/
                    if(evt.target.id == "open_hide_dasti" || evt.target.id == "open_hide_dasti_i")
                    {
                        $(".skin-blue").toggleClass('sidebar-open');
                        return;
                    }
                    else{
                        $(".skin-blue").addClass('sidebar-open');
                        return;
                    }
                }
            });
        </script>
        {{--end of baz o baste shodane right menu e admin, custome shode, taghire name va id haye safhe header_slider.blade.php--}}

        {{--data table--}}
        <script src="{{asset('js/datatable/jquery.datatables.min.js')}}"></script>
        <script>
            $('#table_datatable').DataTable({
                "pageLength": 10,
                "language": {
                    "sEmptyTable":     "هیچ داده‌ای در جدول وجود ندارد",
                    "sInfo":           "نمایش _START_ تا _END_ از _TOTAL_ ردیف",
                    "sInfoEmpty":      "نمایش 0 تا 0 از 0 ردیف",
                    "sInfoFiltered":   "(فیلتر شده از _MAX_ ردیف)",
                    "sInfoPostFix":    "",
                    "sInfoThousands":  ",",
                    "sLengthMenu":     "نمایش _MENU_ ردیف",
                    "sLoadingRecords": "در حال بارگزاری...",
                    "sProcessing":     "در حال پردازش...",
                    "sSearch":         "جستجو:",
                    "sZeroRecords":    "رکوردی با این مشخصات پیدا نشد",
                    "oPaginate": {
                        "sFirst":    "برگه‌ی نخست",
                        "sLast":     "برگه‌ی آخر",
                        "sNext":     "بعدی",
                        "sPrevious": "قبلی"
                    },
                    "oAria": {
                        "sSortAscending":  ": فعال سازی نمایش به صورت صعودی",
                        "sSortDescending": ": فعال سازی نمایش به صورت نزولی"
                    }
                }
            });
            $('#table_datatable_two').DataTable({
                "pageLength": 10,
                "language": {
                    "sEmptyTable":     "هیچ داده‌ای در جدول وجود ندارد",
                    "sInfo":           "نمایش _START_ تا _END_ از _TOTAL_ ردیف",
                    "sInfoEmpty":      "نمایش 0 تا 0 از 0 ردیف",
                    "sInfoFiltered":   "(فیلتر شده از _MAX_ ردیف)",
                    "sInfoPostFix":    "",
                    "sInfoThousands":  ",",
                    "sLengthMenu":     "نمایش _MENU_ ردیف",
                    "sLoadingRecords": "در حال بارگزاری...",
                    "sProcessing":     "در حال پردازش...",
                    "sSearch":         "جستجو:",
                    "sZeroRecords":    "رکوردی با این مشخصات پیدا نشد",
                    "oPaginate": {
                        "sFirst":    "برگه‌ی نخست",
                        "sLast":     "برگه‌ی آخر",
                        "sNext":     "بعدی",
                        "sPrevious": "قبلی"
                    },
                    "oAria": {
                        "sSortAscending":  ": فعال سازی نمایش به صورت صعودی",
                        "sSortDescending": ": فعال سازی نمایش به صورت نزولی"
                    }
                }
            });
        </script>

        {{--New_waiter--}}
        <script>
            function fnctn_loadWaiter(txt){
                $(".new_waiter").find('label').text(txt);
                $(".new_waiter").fadeIn("fast");
                $('button').prop('disabled', true);
                $('a').prop('disabled', true);
                $('input').addClass('input-karnakon');
                $('.allPage').css('opacity', '0.5');
            }
            function fnctn_unloadWaiter(){
                $(".new_waiter").fadeOut("fast");
                $('button').prop('disabled', false);
                $('a').prop('disabled', false);
                $('input').removeClass('input-karnakon');
                $('.allPage').css('opacity', '1');
            }
        </script>

        {{--SWEET ALERT--}}
        <script src="{{asset('js/sweet_alert/sweet_alert_2@9.js')}}"></script>

        {{--CK_EDITOR-4--}}
        <script src="{{asset('js/ckeditor/ckeditor.js')}}"></script>
        <script>
            if($("#ck_editor").length) {
                CKEDITOR.replace('ck_editor', {
                    language: 'fa',
                    content: 'fa',
                    filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",
                    filebrowserUploadMethod: 'form'
                });
            }
            if($("#ck_editor_two").length) {
                CKEDITOR.replace('ck_editor_two', {
                    language: 'fa',
                    content: 'fa',
                    filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",
                    filebrowserUploadMethod: 'form'
                });
            }
        </script>

        {{--SlimSelect--}}
        <script>
            if($("#slim-select").length > 0) {
                new SlimSelect({
                    select: '#slim-select'
                });
            }
            if($("#slim-select_two").length > 0) {
                new SlimSelect({
                    select: '#slim-select_two'
                })
            }
        </script>

        <script>
            $("input").attr("autocomplete", "off");
        </script>

        {{--Make excel from table--}}
        <script src="{{asset('js/TableCSVExport-master/jquery.TableCSVExport.js')}}"></script>
        <script>
            function makeExcelFromTable(tableId, fileName)
            {
                fnctn_loadWaiter("صبر کنید");
                $(".element-hideFromPrint").css('display', 'none');

                setTimeout(function(){
                    $("#"+tableId).TableCSVExport({
                        delivery: "download",
                        filename: fileName+"-"+"{{Carbon\Carbon::now()->toDateString()}}"+".csv"
                    });
                }, 1500)

                setTimeout(function(){
                    $(".element-hideFromPrint").css('display', 'revert');
                    fnctn_unloadWaiter();
                }, 2500);
            }

            function makeExcelFromTableFromDataTable(tableId, fileName)
            {
                fnctn_loadWaiter("صبر کنید");
                $(".element-hideFromPrint").css('display', 'none');

                /*Remove datatable*/
                $('#'+tableId).DataTable().destroy();

                setTimeout(function(){
                    $("#"+tableId).TableCSVExport({
                        delivery: "download",
                        filename: fileName+"-"+"{{Carbon\Carbon::now()->toDateString()}}"+".csv"
                    });
                }, 1500)

                setTimeout(function(){
                    $(".element-hideFromPrint").css('display', 'revert');
                    fnctn_unloadWaiter();

                    /*Kollan reload she khial e hame rahat she*/
                    location.reload();
                }, 2500);
            }
        </script>


        @yield('script_whole')
    </footer>
</html>
