@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'چالش های صفحه اصلی')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                چالش های صفحه اصلی
                -
                آیتم ها
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">
<a class="btn btn-primary" href="{{route('admin.firstPageChallenge.item.create')}}"><i class="fa fa-plus"></i></a>
<a class="btn btn-default" href="{{route('admin.firstPageChallenge.item.index')}}"><i class="fa fa-refresh"></i></a>
                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">
<table id="table_datatable" class="table table-condensed table-hover table-striped">
    <thead>
        <th>#</th>
        <th>ترتیب نمایش</th>
        <th>عنوان</th>
        <th>آیکن</th>
        <th>دسترسی</th>
        <th>وضعیت</th>
        <th>عملیات</th>
    </thead>
    <tbody>
    @if(!empty($items))
        @foreach($items as $key=>$item)
            <tr>
                <td>{{$key+1}}</td>
                <td>
                    {{ $item->sort_order ?? '' }}
                </td>
                <td>
                    {{ $item->title ?? '' }}
                </td>
                <td>
                    <img src="{{ asset($item->icon ?? '') }}" style="max-width: 80px;">
                </td>
                <td>
                    <a href="{{ $item->path() }}" class="btn btn-primary" target="_blank">
                        <i class="fa fa-eye"></i>
                    </a>
                </td>
                <td>
                    @if($item->status)
                        <label style="color: darkgreen;">
                            <i class="fa fa-check-circle"></i>
                            فعال
                        </label>
                    @else
                        <label style="color: darkred;">
                            <i class="fa fa-times-circle"></i>
                            غیرفعال
                        </label>
                    @endif
                </td>
                <td>
                    <a href="{{route('admin.firstPageChallenge.item.edit',$item->id)}}" class="btn btn-warning">
                        <i class="fa fa-pencil"></i>
                    </a>
                    <a href="{{route('admin.firstPageChallenge.item.delete', $item->id)}}" class="btn btn-danger destroy">
                        <i class="fa fa-trash"></i>
                    </a>
                </td>
            </tr>
        @endforeach
    @endif
    </tbody>
</table>
                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')

    {{--delete --}}
    <script>
        $(document).on("click", ".destroy", function(e){
            e.preventDefault();
            var url = $(this).attr('href');
            swal.fire({
                title: "اطمینان دارید؟",
                text: "پس از حذف قابل بازیابی نمی باشد",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "بله, حذف شود",
                cancelButtonText: "خیر"
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>

@endsection
