@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'پیام های صفحه تماس با ما')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                پیام های صفحه تماس با ما
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">

<a href="{{route('admin.contactUsPage.message.delete', $message->id)}}" class="btn btn-danger destroy">
    <i class="fa fa-trash"></i>
</a>
<a class="btn btn-default" href="{{route('admin.contactUsPage.message.index')}}"><i class="fa fa-reply"></i></a>

                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">
<table id="table_datatable" class="table table-condensed table-hover table-striped" style="text-align: center;">
    <tbody>
        <tr>
            <th>
                تاریخ ثبت
            </th>
            <td>
                {{ convert_to_jalali($message->created_at->toDateString()) }}
                <br/>
                {{ $message->created_at->setTimeZone('Asia/Tehran')->toTimeString() }}
            </td>
        </tr>
        <tr>
            <th>نام</th>
            <td>
                {{ $message->name ?? '' }}
            </td>
        </tr>
        <tr>
            <th>ایمیل</th>
            <td>
                {{ $message->email ?? '' }}
            </td>
        </tr>
        <tr>
            <th>
                متن پیام
            </th>
            <td>
                {{ $message->message ?? '' }}
            </td>
        </tr>
    </tbody>
</table>
                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')

    {{--delete --}}
    <script>
        $(document).on("click", ".destroy", function(e){
            e.preventDefault();
            var url = $(this).attr('href');
            swal.fire({
                title: "اطمینان دارید؟",
                text: "پس از حذف قابل بازیابی نمی باشد",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "بله, حذف شود",
                cancelButtonText: "خیر"
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>
    {{--end of delete --}}

@endsection
