@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'پیام های تماس با ما')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                پیام های تماس با ما
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">

<a class="btn btn-default" href="{{route('admin.contactUsPage.message.index')}}"><i class="fa fa-refresh"></i></a>

                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">
<table id="table_datatable" class="table table-condensed table-hover table-striped" style="text-align: center;">
    <thead>
    <tr>
        <td>#</td>
        <td>تاریخ ثبت</td>
        <td>نام</td>
        <td>ایمیل</td>
        <td>وضعیت</td>
        <td>عملیات</td>
    </tr>
    </thead>
    <tbody>
    @if(!empty($messages))
        @foreach($messages as $key=>$message)
            <tr>
                <td>{{$key+1}}</td>
                <td>
                    {{ convert_to_jalali($message->created_at->toDateString()) }}
                    <br/>
                    {{ $message->created_at->setTimeZone('Asia/Tehran')->toTimeString() }}
                </td>
                <td>
                    {{ $message->name ?? '' }}
                </td>
                <td>
                    {{ $message->email ?? '' }}
                </td>
                <td>
                    @if($message->seened_by_admin == true)
                        <label style="color: darkgreen;">
                            <i class="fa fa-check-circle"></i>
                            دیده شده
                        </label>
                    @else
                        <label style="color: darkred;">
                            <i class="fa fa-times-circle"></i>
                            دیده نشده
                        </label>
                    @endif
                </td>
                <td class="element-hideFromPrint">
                    <a href="{{route('admin.contactUsPage.message.show', $message->id)}}" class="btn btn-primary">
                        <i class="fa fa-eye"></i>
                    </a>

                    <a href="{{route('admin.contactUsPage.message.delete', $message->id)}}" class="btn btn-danger destroy">
                        <i class="fa fa-trash"></i>
                    </a>
                </td>
            </tr>
        @endforeach
    @endif
    </tbody>
</table>
                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')

    {{--delete --}}
    <script>
        $(document).on("click", ".destroy", function(e){
            e.preventDefault();
            var url = $(this).attr('href');
            swal.fire({
                title: "اطمینان دارید؟",
                text: "پس از حذف قابل بازیابی نمی باشد",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "بله, حذف شود",
                cancelButtonText: "خیر"
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>
    {{--end of delete --}}

@endsection
