@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style') @endsection
@section('title', 'وبلاگ')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                وبلاگ
                -
                مقالات
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">
<button class="btn btn-primary" type="submit" form="frm"><i class="fa fa-save"></i></button>
<a class="btn btn-default" href="{{route('admin.blog.article.index')}}"><i class="fa fa-reply"></i></a>
                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">

<form id="frm" action="{{ route('admin.blog.article.store') }}" method="post" enctype="multipart/form-data">
    @csrf

    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            وضعیت
        </label>
        <select name="status" class="form-control">
            <option value="">
                انتخاب کنید
            </option>
            <option value="0" @if(old('status')!=null) @if(old('status')=='0') selected @endif @endif>
                غیرفعال
            </option>
            <option value="1" @if(old('status')!=null) @if(old('status')=='1') selected @endif @endif>
                فعال
            </option>
        </select>
        <label class="err_labels">{{$errors->first('status')}}</label>
    </div>
    <div class="form-group col-md-6 col-lg-6">
        <label class="control-label">
            دسته بندی
        </label>
        <select name="article_category_id" class="form-control">
            <option value="">
                انتخاب کنید
            </option>
            @if(!empty($categories))
                @if(count($categories))
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}"
                            @if(old('article_category_id')!=null)
                                @if(old('article_category_id') == $category->id)
                                    selected
                                @endif
                            @endif
                        >
                            {{ $category->title ?? '' }}
                        </option>
                    @endforeach
                @endif
            @endif
        </select>
        <label class="err_labels">{{$errors->first('article_category_id')}}</label>
    </div>

    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            عنوان
        </label>
        <input type="text" name="title" class="form-control" value="{{ old('title') }}">
        <label class="err_labels">{{$errors->first('title')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            نام دسترسی
        </label>
        <input type="text" name="slug" class="form-control" value="{{ old('slug') }}">
        <label class="err_labels">{{$errors->first('slug')}}</label>
    </div>

    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            توضیحات کوتاه
        </label>
        <textarea class="form-control" rows="5" name="short_text">{{ old('short_text') }}</textarea>
        <label class="err_labels">{{$errors->first('short_text')}}</label>
    </div>

    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            متن مقاله
        </label>
        <textarea class="form-control" id="ck_editor" name="text">{{ old('text') }}</textarea>
        <label class="err_labels">{{$errors->first('text')}}</label>
    </div>

    <div class="form-group col-md-12 col-lg-12">
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                تصویر
            </label>
            <label class="err_labels">{{$errors->first('image')}}</label>
            <input type="file" name="image" class="form-control imager">
        </div>
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                پیش نمایش
            </label>
            <div class="image_result">
                <img src="{{asset('images/no_pic.png')}}" style="max-width: 100%;">
            </div>
        </div>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                تصویر برای هدر
            </label>
            <label class="err_labels">{{$errors->first('header_image')}}</label>
            <input type="file" name="header_image" class="form-control imager2">
        </div>
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                پیش نمایش
            </label>
            <div class="image_result2">
                <img src="{{asset('images/no_pic.png')}}" style="max-width: 100%;">
            </div>
        </div>
    </div>

</form>

                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')

    {{--Image--}}
    <script>
        /*** namayesh e tasvire entekhab shode bedoone upload ***/
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $(".image_result").html('');
                    $(".image_result").append('<img id="selected_photos" src="'+e.target.result+'" alt="your image" style="max-width: 100%;"/>');
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        $(document).on("change", ".imager", function(){readURL(this);});

        function readURL2(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $(".image_result2").html('');
                    $(".image_result2").append('<img id="selected_photos" src="'+e.target.result+'" alt="your image" style="max-width: 100%;"/>');
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        $(document).on("change", ".imager2", function(){readURL2(this);});
    </script>

@endsection
