<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Register</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.4 -->
    <link rel="stylesheet" href="{{asset('admin_panel_assets/bootstrap/css/bootstrap.min.css')}}">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{asset('admin_panel_assets/dist/css/AdminLTE.min.css')}}">
    <!-- iCheck -->
    <link rel="stylesheet" href="{{asset('admin_panel_assets/plugins/iCheck/square/blue.css')}}">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <style>
        .captcha_area img{
            width: 100%;
            height: 27px;
        }
    </style>

</head>
<body class="register-page">
<div class="register-box">
    <div class="register-logo">
        <b>Admin</b>LTE
    </div>

    <div class="register-box-body" style="text-align: right;">
        <p class="login-box-msg">ثبت نام</p>
        <form action="{{route('admin.register')}}" method="post">
            {{csrf_field()}}
            <div class="form-group has-feedback">
                <input type="email" name="email" class="form-control" placeholder="ایمیل" required
                       oninvalid="this.setCustomValidity('لطفا ایمیل خود را وارد کنید')"
                       oninput="setCustomValidity('')" maxlength="190" value="{{old('email')}}">
                <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
                @if($errors->has('email'))
                    <label style="color: red;">{{$errors->first('email')}}</label>
                @endif
            </div>
            <div class="form-group has-feedback">
                <input type="number" class="form-control" name="mobile_number" placeholder="تلفن همراه" required
                       oninvalid="this.setCustomValidity('لطفا تلفن همراه خود را وارد کنید')"
                       oninput="setCustomValidity('')" maxlength="11" value="{{old('mobile_number')}}">
                <span class="glyphicon glyphicon-phone form-control-feedback"></span>
                @if($errors->has('mobile_number'))
                    <label style="color: red;">{{$errors->first('mobile_number')}}</label>
                @endif
            </div>
            <div class="form-group has-feedback">
                <input type="password" class="form-control" placeholder="رمز" name="password" required
                       oninvalid="this.setCustomValidity('لطفا رمز را وارد کنید')"
                       oninput="setCustomValidity('')" maxlength="190">
                <span class="glyphicon glyphicon-lock form-control-feedback"></span>
                @if($errors->has('password'))
                    <label style="color: red;">{{$errors->first('password')}}</label>
                @endif
            </div>
            <div class="form-group has-feedback">
                <input type="password" class="form-control" placeholder="رمز" name="password_confirmation" required
                       oninvalid="this.setCustomValidity('لطفا رمز را وارد کنید')"
                       oninput="setCustomValidity('')" maxlength="190">
                <span class="glyphicon glyphicon-lock form-control-feedback"></span>
                @if($errors->has('password_confirmation'))
                    <label style="color: red;">{{$errors->first('password_confirmation')}}</label>
                @endif
            </div>
            <br/>

            <div class="row">
                <div class="col-xs-6">
                    <div class="checkbox icheck">
                        <label>
                            <input name="accept_rules" type="checkbox"> قبول کردن <a href="#"> قوانین </a>
                        </label>
                    </div>
                    @if($errors->has('accept_rules'))
                        <label style="color: red;">{{$errors->first('accept_rules')}}</label>
                    @endif
                </div><!-- /.col -->
                <div class="col-xs-6">
                    <button type="submit" class="btn btn-primary btn-block btn-flat">ثبت نام</button>
                </div><!-- /.col -->
            </div>
        </form>

        <a href="{{route('admin.login')}}" class="text-center">اکانت دارید؟ وارد شوید</a>
    </div><!-- /.form-box -->
</div><!-- /.register-box -->

      <!-- jQuery 2.1.4 -->
<script src="{{asset('admin_panel_assets/plugins/jQuery/jQuery-2.1.4.min.js')}}"></script>
      <!-- Bootstrap 3.3.4 -->
<script src="{{asset('admin_panel_assets/bootstrap/js/bootstrap.min.js')}}"></script>
      <!-- iCheck -->
<script src="{{asset('admin_panel_assets/plugins/iCheck/icheck.min.js')}}"></script>
<script>
    $(function () {
        $('input').iCheck({
            checkboxClass: 'icheckbox_square-blue',
            radioClass: 'iradio_square-blue',
            increaseArea: '20%' // optional
        });
    });
</script>

</body>
</html>
