<!DOCTYPE html>
<html>
<head>
    {{--Google Captcha image challenge--}}
    <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit&hl=fa"></script>

    <meta charset="UTF-8">
    <title>ADMIN | Log in</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.4 -->
    <link rel="stylesheet" href="{{asset('admin_panel_assets/bootstrap/css/bootstrap.min.css')}}">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{asset('admin_panel_assets/dist/css/AdminLTE.min.css')}}">
    <!-- iCheck -->
    <link rel="stylesheet" href="{{asset('admin_panel_assets/plugins/iCheck/square/blue.css')}}">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <style>
        .captcha_area img{
            width: 100%;
            height: 27px;
        }
    </style>
</head>
<body class="login-page" style="    background: #07072a;">
<div class="login-box">
    <div class="login-logo">
        <a href="#" onclick="location.reload();">
            <b style="color: #ededed;text-shadow: 0px 4px 4px red;">
                {{ __('labels.admin_panel') }}
            </b>
        </a>
    </div><!-- /.login-logo -->
    <div class="login-box-body" style="border-radius: 10px;box-shadow: 0px 1px 3px 1px red;">
        <p class="login-box-msg" style="font-weight: bold;font-size: 20px;color: darkblue;">
            {{ __('labels.login') }}
        </p>
        <form action="{{route('admin.login')}}" method="post">
            @if(count($errors) > 0 && empty($errors->first('captcha')))
                <label class="form-control message_area"
                       style="background-color: #ff000099;color: white;text-align: center;border: none;border-radius: 5px;box-shadow: 1px 1px 1px 1px darkred;">
                    {{ __('labels.login_user_or_pass_is_wrong') }}
                </label>
            @endif
            {{csrf_field()}}
            <div class="form-group has-feedback">
                <input type="email" name="email" class="form-control" placeholder="{{ __('labels.email') }}"
                       required>
                <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <input type="password" name="password" class="form-control" placeholder="{{ __('labels.password') }}"
                       required>
                <span class="glyphicon glyphicon-lock form-control-feedback"></span>
            </div>

            <div class="form-group" style="text-align: center;">
                <label class="control-label">
                    {{ __('labels.confirm_you_are_not_a_robot') }}
                </label>
            </div>
            <div class="form-group">
                <div class="recaptcha" id="g-recaptcha1"></div>
            </div>
            <br/>
            <div class="row" style="margin-top: 10px;">
                <div class="col-xs-12">
                    {{--<div class="checkbox icheck">
                        <label>
                            <input type="checkbox"> مرا به خاطر بسپار
                        </label>
                    </div>--}}
                </div>
                <div class="col-xs-12">
                    <button type="submit" class="btn btn-success btn-block btn-flat" style="background: #148b00;font-weight: bold;color: white;text-shadow: 0px 4px 4px darkblue;font-size: 16px;height: auto;border-radius: 7px;box-shadow: 0px 3px 6px 1px #00008b;border: none;">
                        {{ __('labels.login') }}
                    </button>
                </div>
                <div class="col-xs-12">
                    <hr style="margin: 2px;"/>
                    <a href="{{url('/')}}" class="btn btn-default form-control" style="background: darkblue;font-weight: bold;color: white;text-shadow: 0px 4px 4px red;font-size: 16px;height: auto;border-radius: 7px;box-shadow: 0px 3px 6px 1px #eb8787;border: none;">
                        {{ __('labels.back_to_main_page') }}
                    </a>
                </div>
            </div>
        </form>
    </div><!-- /.login-box-body -->
</div><!-- /.login-box -->

<!-- jQuery 2.1.4 -->
<script src="{{asset('admin_panel_assets/plugins/jQuery/jQuery-2.1.4.min.js')}}"></script>
<!-- Bootstrap 3.3.4 -->
<script src="{{asset('admin_panel_assets/bootstrap/js/bootstrap.min.js')}}"></script>
<!-- iCheck -->
<script src="{{asset('admin_panel_assets/plugins/iCheck/icheck.min.js')}}"></script>

{{--Google Captcha image challenge--}}
<script>
    // setTimout is necessary
    $(document).ready(function() {
        setTimeout(function () {

            $('.recaptcha').each(function () {
                grecaptcha.render(this.id, {
                    'sitekey': '6LdVkwkUAAAAACeeETRX--v9Js0vWyjQOTIZxxeB',
                    "theme": "light"
                });
            });

        }, 500);
    });
</script>

<script>
    $(function () {
        $('input').iCheck({
            checkboxClass: 'icheckbox_square-blue',
            radioClass: 'iradio_square-blue',
            increaseArea: '20%' // optional
        });
    });
</script>
<script>
    setTimeout(function () {
        $(".message_area").slideUp("slow");
    }, 5000);
</script>

</body>
</html>
