<!DOCTYPE html>
<html>
<head>
    {{--Google Captcha image challenge--}}
    <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit&hl=fa"></script>

    <meta charset="UTF-8">
    <title>ADMIN | Log in</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.4 -->
    <link rel="stylesheet" href="{{asset('admin_panel_assets/bootstrap/css/bootstrap.min.css')}}">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="{{asset('admin_panel_assets/plugins/iCheck/square/blue.css')}}">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <link rel="preconnect" href="//fdn.fontcdn.ir">
    <link rel="preconnect" href="//v1.fontapi.ir">
    <link href="https://v1.fontapi.ir/css/Koodak" rel="stylesheet">
    <style>
        @import url('https://v1.fontapi.ir/css/Koodak');
        body *{
            font-family: Koodak, sans-serif;
        }
        .AdminSessionMessage{
            position: absolute;
            top: 6%;
            right: 6%;
            left: unset;
            z-index: 999999999999999;
            min-width: 40%;
            text-align: right;
            direction: ltr;
        }
        .AdminSessionMessage div{
            font-weight: bold;
            color: black;
        }
        .AdminSessionMessage div button{
            width: 5%;
        }
        .captcha_area img{
            width: 100%;
            height: 27px;
        }

        /*NEW!*/
        @import url('https://fonts.googleapis.com/css2?family=Bebas+Neue&display=swap');

        *{
            margin: 0;
            padding: 0;
            font-family: 'Trebuchet MS', 'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Arial, sans-serif;
        }

        section{
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            width: 100%;

            background: #A691AB;
        }

        .content{
            display: flex;
            flex-direction: row;
            width: 750px;
            height: 460px;
            border-radius: 10px;

            background: #fff;
        }

        .left{
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            width: 250px;
            border-top-left-radius: 10px;
            border-bottom-left-radius: 10px;

            background: url("https://i.postimg.cc/vmK4vkf0/neon-bg.jpg");
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .left img{
            width: 100px;
        }

        .left h1{
            margin-top: 10px;
            font-size: 3em;
            font-weight: 100;
            font-family: 'Bebas Neue', sans-serif;
            color: #fff;
        }

        .right{
            margin: 20px auto;
            padding: 10px;
        }

        .inputbox{
            margin: 8px 0px;
            width: 350px;
            height: fit-content;
        }

        input {
            margin-top: 4px;
            padding: 5px;
            width: 100%;
            height: 28px;
            text-indent: 9px;
            border: none;
            border-radius: 2px;

            background: rgba(128, 128, 128, 0.2);
        }

        input:hover{
            box-shadow: 0px 0px 5px 1px rgba(0, 0, 0, 0.5);
        }

        .right .title h2{
            text-align: center;
            font-size: 1.8em;
            margin-bottom: 20px;
        }

        .inputbox label{
            font-size: 1em;
        }

        input::placeholder{
            text-indent: 10px;
        }

        .create{
            display: flex;
            justify-content: center;
            width: 360px;
        }

        .create button{
            margin-top: 5px;
            width: 250px;
            height: 35px;
            border: none;
            border-radius: 25px;

            color: #fff;
            background: #000;
        }

        .additional p{
            margin-top: 5px;
            font-size: 11px;
            text-align: center;
        }

        .additional p span{
            color: blue;
        }

        .additional p span:hover{
            text-decoration: underline;
        }

        .or{
            margin-top: 10px;
            font-size: 1em;
            text-align: center;
        }

        .sign{
            display: flex;
            justify-content: space-around;
            margin-top: 15px;
        }

        button{
            width: 160px;
            height: 35px;
            padding: 5px;
            border-radius: 25px;

            background: none;
            border: 2px solid #000;
        }
        .inputbox-a{
            width: 160px;
            height: 35px;
            padding: 5px;
            border-radius: 25px;
            background: none;
            border: 2px solid #000;
            color: black;
            cursor: pointer;
        }
        /* Responsiveness:Start */
        @media screen and (max-width:780px) {
            .AdminSessionMessage{
                min-width: 75%;
            }
            .content{
                flex-direction: column;
                width: 400px;
                height: fit-content;
                margin: 20px auto;
            }
            .left{
                height: 250px;
                width: 100%;
                border-radius: 0px;
                border-top-left-radius: 10px;
                border-top-right-radius: 10px;
            }
        }
        @media screen and (max-width:425px) {
            .content{
                width: 100%;
                margin: 0px;
                border-radius: 0px;
            }
            .left{
                width: 100%;
                border-radius: 0px;
            }
            /*MINE!*/
            .title h2{
                margin-top: 0;
                padding: 0;
            }
            body{
                padding: 10px;
                /*overflow-x: hidden;*/
                overflow: hidden;
            }
            .inputbox{
                /*display: contents;*/
                width: 100%;
            }
            .inputbox label{
                /*text-align: center;*/
                display: block;
            }
            .inputbox input{
                /*text-align: center;*/
                /*width: 90%;*/
                margin-bottom: 10px;
            }
            .recaptcha{
                display: contents;
            }
            .create{
                display: unset;
            }
            .create button{
                margin-top: 20px;
                width: 100%;
            }
        }
        /* Responsiveness:End */


        .inputbox{
            text-align: right;
            direction: rtl;
        }
    </style>
</head>
<body class="login-page" style="background: #07072a;">

<div class="AdminSessionMessage">
    @include('Admin.Layouts.sessionMessage')
</div>

<div class="login-box">
    <section>
        <div class="content">

            <div class="left">
                <img src="{{ asset(settings('header_logo') ?? 'https://i.postimg.cc/8CCmX23W/icon.png') }}" alt="icon">
                <h1>
                    {{ env('APP_NAME') }}
                </h1>
            </div>

            <div class="right">
                <div class="title">
                    <h2>
                        پنل ادمین
                    </h2>
                </div>
                <div class="form">
                    <form action="{{route('admin.login')}}" method="post">
                        {{csrf_field()}}
                        <div class="inputbox">
                            <label>
                                ایمیل
                            </label>
                            <input type="email" name="email" required>
                        </div>
                        <div class="inputbox">
                            <label>
                                رمز عبور
                            </label>
                            <input type="password" name="password" required>
                        </div>
                        <div class="inputbox">
                            <label>
                                تایید کنید که ربات نیستید
                            </label>
                            <div class="recaptcha" id="g-recaptcha1"></div>
                        </div>
                        <div class="create">
                            <button type="submit">
                                ورود
                            </button>
                        </div>
                    </form>
                    <div class="or">
                        <div class="sign">
                            <a class="inputbox-a">
                                <ion-icon name="home"></ion-icon>
                                <span>
                                    بازگشت به صفحه اصلی
                                </span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>

</div><!-- /.login-box -->

<!-- jQuery 2.1.4 -->
<script src="{{asset('admin_panel_assets/plugins/jQuery/jQuery-2.1.4.min.js')}}"></script>
<!-- Bootstrap 3.3.4 -->
<script src="{{asset('admin_panel_assets/bootstrap/js/bootstrap.min.js')}}"></script>
<!-- iCheck -->
<script src="{{asset('admin_panel_assets/plugins/iCheck/icheck.min.js')}}"></script>

{{--Google captcha image challenge--}}
<script>
    loadCaptcha();
    function loadCaptcha(){
        // setTimout is necessary
        $(document).ready(function() {
            setTimeout(function() {
                $('.recaptcha').each(function() {
                    grecaptcha.render(this.id, {
                        'sitekey': '6LdVkwkUAAAAACeeETRX--v9Js0vWyjQOTIZxxeB',
                        "theme":"light"
                    });
                    flag = true;
                });

            }, 500);
        });

        /*adding css to appended recaptcha*/
        $(document).ready(function() {
            setTimeout(function() {
                $(".recaptcha").each(function(){
                    $(this).find('div').css('margin', '0 auto');
                });
            }, 600);
        });
    }
    /*Check kone ke age captcha load nashode bood, Dobare darkhast she*/
    setInterval(function(){
        if(!$("#rc-anchor-container").length){
            /*if($("#rc-anchor-container").length != 0){*/
            loadCaptcha();
        }
    }, 2000);
</script>

<script>
    $(function () {
        $('input').iCheck({
            checkboxClass: 'icheckbox_square-blue',
            radioClass: 'iradio_square-blue',
            increaseArea: '20%' // optional
        });
    });
</script>
<script>
    setTimeout(function () {
        $(".message_area").slideUp("slow");
    }, 5000);
</script>

<script>
    setTimeout(function(){
        // $(".AdminSessionMessage").fadeOut("slow");
    }, 5000);
</script>

</body>
</html>
