@extends('Admin.Layouts.header_slider')
@section('metas')  @endsection
@section('head')  @endsection
@section('style')
    <style>
        th{
            text-align: center;
            font-size: 12px;
            font-weight: bold;
        }
        td{
            text-align: center;
            font-size: 12px;
        }
        .lbl-access{
            font-size: 10px;
            font-weight: bold;
        }
    </style>
@endsection
@section('title', 'مدیران')

@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                مدیران
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-default">
                            <div class="row page-header">
                                <div class="col-lg-11 col-md-11 col-sm-11 col-xs-11" style="text-align: left;">
<a href="{{route('admin.admins.create')}}"><button class="btn btn-primary"><i class="fa fa-plus"></i></button></a>
<a href="{{route('admin.admins.list')}}"><button class="btn btn-default"><i class="fa fa-refresh"></i></button></a>
                                </div>
                                <div class="col-lg-1 col-md-1 col-sm-1 col-xs-1"></div>
                            </div>
                            <div class="panel-body">
                                <div id="morris-area-chart">

<table id="table_datatable" class="table table-striped table-condensed" style="text-align: center;">
    <thead>
    <th>#</th>
    <th>ایمیل</th>
    <th>تلفن همراه</th>
    <th>تاریخ ثبت نام</th>
    <th>دسترسی ها</th>
    <th></th>
    </thead>
    <tbody>
        @if(!empty($admins))
            @foreach($admins as $key=>$admin)
                <tr>
                    <td>{{$key+1}}</td>
                    <td>
                        {{$admin->email ?? ''}}
                    </td>
                    <td>
                        {{$admin->mobile_number ?? ''}}
                    </td>
                    <td>
{{convert_to_jalali($admin->created_at->toDateString())}} - {{$admin->created_at->setTimeZone("Asia/Tehran")->toTimeString()}}
                    </td>
                    <td>
                        @if(count($admin->access))
                            @foreach($admin->access as $access)
                                <label class="lbl-access">
                                    {{$access->title ?? ''}}
                                </label>
                                <br/>
                            @endforeach
                        @else
                            <label class="lbl-access" style="color: red;">
                                <i class="fa fa-times"></i>
                                بدون دسترسی
                            </label>
                        @endif
                    </td>
                    <td>
                        <a href="{{route('admin.admins.edit', $admin->id)}}" class="btn btn-warning">
                            <i class="fa fa-pencil"></i>
                        </a>
                        <a href="{{route('admin.admins.destroy', $admin->id)}}" class="btn btn-danger destroy">
                            <i class="fa fa-trash"></i>
                        </a>
                    </td>
                </tr>
            @endforeach
        @endif
    </tbody>
</table>

                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')
    <script>
        $(document).on("click", ".destroy", function(e){
            e.preventDefault();
            var url = $(this).attr("href");
            swal.fire({
                title: '{{ __("labels.are_you_sure") }}',
                text: '{{ __("labels.delete_confirm_text") }}',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: '{{ __("labels.yes_delete_this") }}',
                cancelButtonText: '{{ __("labels.no") }}'
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>
@endsection
