@extends('Admin.Layouts.header_slider')
@section('head')  @endsection
@section('style')

    <style>
        .lbl-splitter{
            width: 100%;
            text-align: center;
            font-weight: bold;
            color: darkblue;
            border-top: 1px dotted;
        }
    </style>

@endsection
@section('title', 'صفحه درباره ما')
@section('content')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                صفحه درباره ما
            </h1>
        </section>
        <div id="wrapper">
            <!-- Navigation -->
            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 page-header" style="text-align: left;">

<a class="btn btn-warning" href="{{route('front.aboutUsPage.index')}}" target="_blank">
    پیش نمایش
    <i class="fa fa-eye"></i>
</a>
<button type="submit" form="frm" class="btn btn-primary"><i class="fa fa-save"></i></button>
<a class="btn btn-default" href="{{route('admin.aboutUsPage.index')}}"><i class="fa fa-refresh"></i></a>

                        </div>
                        <!-- /.col-lg-12 -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div id="morris-area-chart">
<form action="{{route('admin.aboutUsPage.store')}}" method="post" id="frm" enctype="multipart/form-data">
    {{csrf_field()}}

    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            وضعیت
        </label>
        <select class="form-control" name="whole_page_status">
            <option value="0" @if(old('whole_page_status', $aboutUs->whole_page_status ?? '') == 0) selected @endif>
                غیرفعال
            </option>
            <option value="1" @if(old('whole_page_status', $aboutUs->whole_page_status ?? '') == 1) selected @endif>
                فعال
            </option>
        </select>
        <label class="err_labels">{{$errors->first('whole_page_status')}}</label>
    </div>



    <div class="form-group col-lg-12 col-md-12">
        <label class="lbl-splitter">
            بخش بالای اسلایدشو
        </label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            وضعیت
        </label>
        <select class="form-control" name="slideshow_status">
            <option value="0" @if(old('slideshow_status', $aboutUs->slideshow_status ?? '') == 0) selected @endif>
                غیرفعال
            </option>
            <option value="1" @if(old('slideshow_status', $aboutUs->slideshow_status ?? '') == 1) selected @endif>
                فعال
            </option>
        </select>
        <label class="err_labels">{{$errors->first('slideshow_status')}}</label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            عنوان
        </label>
        <input type="text" class="form-control" name="slideshow_title" value="{{old('slideshow_title', $aboutUs->slideshow_title ?? '')}}">
        <label class="err_labels">{{$errors->first('slideshow_title')}}</label>
    </div>
    <div class="form-group col-lg-12 col-md-12">
        <label class="control-label">
            متن
        </label>
        <textarea rows="5" class="form-control" name="slideshow_text">{{old('slideshow_text', $aboutUs->slideshow_text ?? '')}}</textarea>
        <label class="err_labels">{{$errors->first('slideshow_text')}}</label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            عنوان دکمه
        </label>
        <input type="text" class="form-control" name="slideshow_button_title" value="{{old('slideshow_button_title', $aboutUs->slideshow_button_title ?? '')}}">
        <label class="err_labels">{{$errors->first('slideshow_button_title')}}</label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            لینک دکمه
        </label>
        <input type="text" class="form-control" name="slideshow_button_link" value="{{old('slideshow_button_link', $aboutUs->slideshow_button_link ?? '')}}">
        <label class="err_labels">{{$errors->first('slideshow_button_link')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                تصویر
            </label>
            <label class="err_labels">{{$errors->first('slideshow_image')}}</label>
            <input type="file" name="slideshow_image" class="form-control imager">
        </div>
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                پیش نمایش
            </label>
            <div class="image_result">
                <img src="{{asset($aboutUs->slideshow_image ?? 'images/no_pic.png')}}" style="width: 150px;">
            </div>
        </div>
    </div>





    <div class="form-group col-lg-12 col-md-12">
        <label class="lbl-splitter">
            بخش محتوا
        </label>
    </div>
    <div class="form-group col-lg-12 col-md-12">
        <label class="control-label">
            محتوا
        </label>
        <textarea class="form-control" name="body" id="ck_editor">{{old('body', $aboutUs->body ?? '')}}</textarea>
        <label class="err_labels">{{$errors->first('body')}}</label>
    </div>
    <div class="form-group col-lg-12 col-md-12">
        <label class="control-label">
            آیتم ها
        </label>
        <table class="table table-condensed table-condenced table-hover table-stripped" id="tbl-body_items">
            <thead>
                <th>ترتیب نمایش</th>
                <th>عنوان</th>
                <th>تصویر</th>
                <th>متن</th>
                <th>حذف</th>
            </thead>
            <tbody>
                @if(!empty($aboutUs->body_items))
                    @if(!empty(json_decode($aboutUs->body_items)))
                        @foreach(json_decode($aboutUs->body_items) as $bodyItem)
                            <tr>
                                <td>
                                    <input type="number" class="form-control" name="body_items_sort_orders[]" value="{{$bodyItem->sort_order ?? ''}}">
                                </td>
                                <td>
                                    <input type="text" class="form-control" name="body_items_titles[]" value="{{$bodyItem->title ?? ''}}">
                                </td>
                                <td>
                                    <input type="file" class="form-control" name="body_items_images[]">
                                    <input type="hidden" name="body_items_images[]" value="{{$bodyItem->image ?? ''}}">
                                    <br/>
                                    <label>
                                        تصویر فعلی
                                        <img src="{{asset($bodyItem->image)}}" style="height: 50px;">
                                    </label>
                                </td>
                                <td>
                                    <textarea class="form-control" name="body_items_texts[]" rows="3">{{$bodyItem->text ?? ''}}</textarea>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger form-control btn-remove-tbl-body_items">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                @endif
                <tr>
                    <td>
                        <input type="number" class="form-control" name="body_items_sort_orders[]">
                    </td>
                    <td>
                        <input type="text" class="form-control" name="body_items_titles[]">
                    </td>
                    <td>
                        <input type="file" class="form-control" name="body_items_images[]">
                    </td>
                    <td>
                        <textarea class="form-control" name="body_items_texts[]" rows="3"></textarea>
                    </td>
                    <td>
                        <button type="button" class="btn btn-danger form-control btn-remove-tbl-body_items">
                            <i class="fa fa-trash"></i>
                        </button>
                    </td>
                </tr>
            </tbody>
            <tfoot>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>
                        <button type="button" class="btn btn-primary form-control btn-add-tbl-body_items">
                            <i class="fa fa-plus-circle"></i>
                        </button>
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>




    <div class="form-group col-lg-12 col-md-12">
        <label class="lbl-splitter">
            بخش پایینی
        </label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            وضعیت
        </label>
        <select class="form-control" name="bottom_body_status">
            <option value="0" @if(old('bottom_body_status', $aboutUs->bottom_body_status ?? '') == 0) selected @endif>
                غیرفعال
            </option>
            <option value="1" @if(old('bottom_body_status', $aboutUs->bottom_body_status ?? '') == 1) selected @endif>
                فعال
            </option>
        </select>
        <label class="err_labels">{{$errors->first('bottom_body_status')}}</label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            عنوان
        </label>
        <input type="text" class="form-control" name="bottom_body_title" value="{{old('bottom_body_title', $aboutUs->bottom_body_title ?? '')}}">
        <label class="err_labels">{{$errors->first('bottom_body_title')}}</label>
    </div>
    <div class="form-group col-lg-12 col-md-12">
        <label class="control-label">
            متن
        </label>
        <textarea class="form-control" name="bottom_body_text" rows="10">{{old('bottom_body_text', $aboutUs->bottom_body_text ?? '')}}</textarea>
        <label class="err_labels">{{$errors->first('bottom_body_text')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                تصویر
            </label>
            <label class="err_labels">{{$errors->first('bottom_body_image')}}</label>
            <input type="file" name="bottom_body_image" class="form-control imager2">
        </div>
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                پیش نمایش
            </label>
            <div class="image_result2">
                <img src="{{asset($aboutUs->bottom_body_image ?? 'images/no_pic.png')}}" style="width: 150px;">
            </div>
        </div>
    </div>
    <div class="form-group col-lg-12 col-md-12">
        <label class="control-label">
            اشخاص
        </label>
        <table class="table table-condensed table-condenced table-hover table-stripped" id="tbl-persons">
            <thead>
                <th>ترتیب نمایش</th>
                <th>عنوان</th>
                <th>تصویر</th>
                <th>متن</th>
                <th>حذف</th>
            </thead>
            <tbody>
                @if(!empty($aboutUs->persons))
                    @if(!empty(json_decode($aboutUs->persons)))
                        @foreach(json_decode($aboutUs->persons) as $person)
                            <tr>
                                <td>
                                    <input type="number" class="form-control" name="persons_sort_orders[]" value="{{$person->sort_order ?? ''}}">
                                </td>
                                <td>
                                    <input type="text" class="form-control" name="persons_titles[]" value="{{$person->title ?? ''}}">
                                </td>
                                <td>
                                    <input type="file" class="form-control" name="persons_images[]">
                                    <input type="hidden" name="persons_images[]" value="{{$person->image ?? ''}}">
                                    <br/>
                                    <label>
                                        تصویر فعلی
                                        <img src="{{asset($person->image)}}" style="height: 50px;">
                                    </label>
                                </td>
                                <td>
                                    <textarea class="form-control" name="persons_texts[]" rows="3">{{$person->text ?? ''}}</textarea>
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger form-control btn-remove-tbl-persons">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                @endif
                <tr>
                    <td>
                        <input type="number" class="form-control" name="persons_sort_orders[]">
                    </td>
                    <td>
                        <input type="text" class="form-control" name="persons_titles[]">
                    </td>
                    <td>
                        <input type="file" class="form-control" name="persons_images[]">
                    </td>
                    <td>
                        <textarea class="form-control" name="persons_texts[]" rows="3"></textarea>
                    </td>
                    <td>
                        <button type="button" class="btn btn-danger form-control btn-remove-tbl-persons">
                            <i class="fa fa-trash"></i>
                        </button>
                    </td>
                </tr>
            </tbody>
            <tfoot>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>
                        <button type="button" class="btn btn-primary form-control btn-add-tbl-persons">
                            <i class="fa fa-plus-circle"></i>
                        </button>
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>





    <div class="form-group col-lg-12 col-md-12">
        <label class="lbl-splitter">
            زیر اسلایدشو
        </label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            وضعیت
        </label>
        <select class="form-control" name="bottom_slideshow_status">
            <option value="0" @if(old('bottom_slideshow_status', $aboutUs->bottom_slideshow_status ?? '') == 0) selected @endif>
                غیرفعال
            </option>
            <option value="1" @if(old('bottom_slideshow_status', $aboutUs->bottom_slideshow_status ?? '') == 1) selected @endif>
                فعال
            </option>
        </select>
        <label class="err_labels">{{$errors->first('bottom_slideshow_status')}}</label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            عنوان
        </label>
        <input type="text" class="form-control" name="bottom_slideshow_title" value="{{old('bottom_slideshow_title', $aboutUs->bottom_slideshow_title ?? '')}}">
        <label class="err_labels">{{$errors->first('bottom_slideshow_title')}}</label>
    </div>
    <div class="form-group col-lg-12 col-md-12">
        <label class="control-label">
            متن
        </label>
        <textarea rows="5" class="form-control" name="bottom_slideshow_text">{{old('bottom_slideshow_text', $aboutUs->bottom_slideshow_text ?? '')}}</textarea>
        <label class="err_labels">{{$errors->first('bottom_slideshow_text')}}</label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            عنوان دکمه
        </label>
        <input type="text" class="form-control" name="bottom_slideshow_button_title" value="{{old('bottom_slideshow_button_title', $aboutUs->bottom_slideshow_button_title ?? '')}}">
        <label class="err_labels">{{$errors->first('bottom_slideshow_button_title')}}</label>
    </div>
    <div class="form-group col-lg-6 col-md-6">
        <label class="control-label">
            لینک دکمه
        </label>
        <input type="text" class="form-control" name="bottom_slideshow_button_link" value="{{old('bottom_slideshow_button_link', $aboutUs->bottom_slideshow_button_link ?? '')}}">
        <label class="err_labels">{{$errors->first('bottom_slideshow_button_link')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                تصویر
            </label>
            <label class="err_labels">{{$errors->first('bottom_slideshow_image')}}</label>
            <input type="file" name="bottom_slideshow_image" class="form-control imager3">
        </div>
        <div class="form-group col-md-6 col-lg-6">
            <label class="control-label">
                پیش نمایش تصویر
            </label>
            <div class="image_result3">
                <img src="{{asset($aboutUs->bottom_slideshow_image ?? 'images/no_pic.png')}}" style="width: 150px;">
            </div>
        </div>
    </div>


    {{--SEO--}}
    <div class="form-group col-md-12 col-lg-12">
        <hr/>
        <label class="control-label" style="padding-right: 10px;">Seo</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            عنوان سئو
        </label>
        <input type="text" class="form-control" name="seo_title" value="{{$aboutUs->seo_title ?? ''}}">
        <label class="err_labels">{{$errors->first('seo_title')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            سئو دسکریپشن
        </label>
        <textarea name="seo_description" class="form-control" placeholder="">{{$aboutUs->seo_description ?? ''}}</textarea>
        <label class="err_labels">{{$errors->first('seo_description')}}</label>
    </div>
    <div class="form-group col-md-12 col-lg-12">
        <label class="control-label">
            سئو کی وردز
        </label>
        <textarea name="seo_keywords" class="form-control" placeholder="{{ __('labels.seo_tag_example') }}">{{$aboutUs->seo_keywords ?? ''}}</textarea>
        <label style="color: blue;font-weight: bold; font-size: 12px;">
            <i class="fa fa-info-circle"></i>
            {{ __('labels.seo_tag_desc') }}
        </label>
        <label class="err_labels">{{$errors->first('seo_keywords')}}</label>
    </div>

</form>
                                </div>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->
        </div>
    </div>
@endsection

@section('script_whole')

    {{--<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>--}}
    <script>
        /*** namayesh e tasvire entekhab shode bedoone upload ***/
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $(".image_result").html('');
                    $(".image_result").append('<img id="selected_photos" src="'+e.target.result+'" alt="your image" style="width: 150px;"/>');
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        function readURL2(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $(".image_result2").html('');
                    $(".image_result2").append('<img id="selected_photos" src="'+e.target.result+'" alt="your image" style="width: 150px;"/>');
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        function readURL3(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $(".image_result3").html('');
                    $(".image_result3").append('<img id="selected_photos" src="'+e.target.result+'" alt="your image" style="width: 150px;"/>');
                }
                reader.readAsDataURL(input.files[0]);
            }
        }

        $(document).on("change", ".imager", function(){
            readURL(this);
        });
        $(document).on("change", ".imager2", function(){
            readURL2(this);
        });
        $(document).on("change", ".imager3", function(){
            readURL3(this);
        });
    </script>
    {{--end of namayesh e aks bad az entekhab--}}


    <script>
        $(".btn-add-tbl-body_items").on("click", function(){
            var html = '';

            html += '<tr>';

            html += '<td>';
            html += '<input type="number" class="form-control" name="body_items_sort_orders[]">';
            html += '</td>';

            html += '<td>';
            html += '<input type="text" class="form-control" name="body_items_titles[]">';
            html += '</td>';

            html += '<td>';
            html += '<input type="file" class="form-control" name="body_items_images[]">';
            html += '</td>';

            html += '<td>';
            html += '<textarea class="form-control" name="body_items_texts[]" rows="3"></textarea>';
            html += '</td>';

            html += '<td>';
            html += '<button type="button" class="btn btn-danger form-control btn-remove-tbl-body_items">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '</td>';

            html += '</tr>';

            $("#tbl-body_items").find('tbody').append(html);
        });
        $(document).on("click", ".btn-remove-tbl-body_items", function(){
            $(this).closest('tr').remove();
        });
    </script>

    <script>
        $(".btn-add-tbl-persons").on("click", function(){
            var html = '';

            html += '<tr>';

            html += '<td>';
            html += '<input type="number" class="form-control" name="persons_sort_orders[]">';
            html += '</td>';

            html += '<td>';
            html += '<input type="text" class="form-control" name="persons_titles[]">';
            html += '</td>';

            html += '<td>';
            html += '<input type="file" class="form-control" name="persons_images[]">';
            html += '</td>';

            html += '<td>';
            html += '<textarea class="form-control" name="persons_texts[]" rows="3"></textarea>';
            html += '</td>';

            html += '<td>';
            html += '<button type="button" class="btn btn-danger form-control btn-remove-tbl-persons">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '</td>';

            html += '</tr>';

            $("#tbl-persons").find('tbody').append(html);
        });
        $(document).on("click", ".btn-remove-tbl-persons", function(){
            $(this).closest('tr').remove();
        });
    </script>

@endsection






