<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => ':attribute должны быть приняты.',
    'active_url' => ':attribute недействительный URL-адрес.',
    'after' => ':attribute должна быть дата после :date.',
    'after_or_equal' => ':attribute должна быть датой после или равной :date.',
    'alpha' => ':attribute может содержать только буквы.',
    'alpha_dash' => ':attribute может содержать только буквы, цифры, дефисы и символы подчеркивания.',
    'alpha_num' => ':attribute может содержать только буквы и цифры.',
    'array' => ':attribute должен быть массивом.',
    'before' => ':attribute должна быть дата до :date.',
    'before_or_equal' => ':attribute должна быть датой до или равной :date.',
    'between' => [
        'numeric' => ':attribute должно быть между :min а также :max.',
        'file' => ':attribute должно быть между :min а также :max килобайты.',
        'string' => ':attribute должно быть между :min а также :max персонажи.',
        'array' => ':attribute должно быть между :min а также :max Предметы.',
    ],
    'boolean' => ':attribute поле должно быть истинным или ложным.',
    'confirmed' => ':attribute подтверждение не совпадает.',
    'date' => ':attribute не является действительной датой.',
    'date_equals' => ':attribute должна быть дата, равная :date.',
    'date_format' => ':attribute не соответствует формату :format.',
    'different' => ':attribute а также :other должно быть другим.',
    'digits' => ':attribute должно быть :digits цифры.',
    'digits_between' => ':attribute должно быть между :min а также :max цифры.',
    'dimensions' => ':attribute имеет недопустимые размеры изображения.',
    'distinct' => ':attribute поле имеет повторяющееся значение.',
    'email' => ':attribute Адрес эл. почты должен быть действительным.',
    'ends_with' => ':attribute должен заканчиваться одним из следующих: :values.',
    'exists' => 'Выбранный :attribute является недействительным.',
    'file' => ':attribute должен быть файл.',
    'filled' => ':attribute поле должно иметь значение.',
    'gt' => [
        'numeric' => ':attribute должно быть больше, чем :value.',
        'file' => ':attribute должно быть больше, чем :value килобайты.',
        'string' => ':attribute должно быть больше, чем :value персонажи.',
        'array' => ':attribute должно быть больше, чем :value Предметы.',
    ],
    'gte' => [
        'numeric' => ':attribute должно быть больше или равно :value.',
        'file' => ':attribute должно быть больше или равно :value килобайты.',
        'string' => ':attribute должно быть больше или равно :value персонажи.',
        'array' => ':attribute должны быть :value предметы или больше.',
    ],
    'image' => ':attribute должно быть изображение.',
    'in' => 'Выбранный :attribute является недействительным.',
    'in_array' => ':attribute поле не существует в :other.',
    'integer' => ':attribute должно быть целым числом.',
    'ip' => ':attribute должен быть действительным IP-адресом.',
    'ipv4' => ':attribute должен быть действительным адресом IPv4.',
    'ipv6' => ':attribute должен быть действительным адресом IPv6.',
    'json' => ':attribute должна быть допустимой строкой JSON.',
    'lt' => [
        'numeric' => ':attribute должно быть меньше, чем :value.',
        'file' => ':attribute должно быть меньше, чем :value килобайты.',
        'string' => ':attribute должно быть меньше, чем :value персонажи.',
        'array' => ':attribute должно быть меньше, чем :value Предметы.',
    ],
    'lte' => [
        'numeric' => ':attribute должно быть меньше или равно :value.',
        'file' => ':attribute должно быть меньше или равно :value килобайты.',
        'string' => ':attribute должно быть меньше или равно :value персонажи.',
        'array' => ':attribute не должен иметь более :value Предметы.',
    ],
    'max' => [
        'numeric' => ':attribute не может быть больше, чем :max.',
        'file' => ':attribute не может быть больше, чем :max килобайты.',
        'string' => ':attribute не может быть больше, чем :max персонажи.',
        'array' => ':attribute может иметь не более :max Предметы.',
    ],
    'mimes' => ':attribute должен быть файл типа: :values.',
    'mimetypes' => ':attribute должен быть файл типа: :values.',
    'min' => [
        'numeric' => ':attribute должен быть не менее :min.',
        'file' => ':attribute должен быть не менее :min килобайты.',
        'string' => ':attribute должен быть не менее :min персонажи.',
        'array' => ':attribute должен иметь по крайней мере :min Предметы.',
    ],
    'not_in' => 'Выбранный :attribute является недействительным.',
    'not_regex' => ':attribute формат является недействительным.',
    'numeric' => ':attribute должно быть числом.',
    'password' => 'Пароль неверен.',
    'present' => ':attribute поле должно присутствовать.',
    'regex' => ':attribute формат является недействительным.',
    'required' => ':attribute Поле, обязательное для заполнения.',
    'required_if' => ':attribute поле обязательно, когда :other является :value.',
    'required_unless' => ':attribute поле обязательно, если только :other в :values.',
    'required_with' => ':attribute поле обязательно, когда :values является подарок.',
    'required_with_all' => ':attribute поле обязательно, когда :values присутствуют.',
    'required_without' => ':attribute поле обязательно, когда :values нет.',
    'required_without_all' => ':attribute поле обязательно, когда никто of :values присутствуют.',
    'same' => ':attribute а также :other должен соответствовать.',
    'size' => [
        'numeric' => ':attribute должно быть :size.',
        'file' => ':attribute должно быть :size килобайты.',
        'string' => ':attribute должно быть :size персонажи.',
        'array' => ':attribute должен содержать :size Предметы.',
    ],
    'starts_with' => ':attribute должен начинаться с одного из следующих: :values.',
    'string' => ':attribute должна быть строка.',
    'timezone' => ':attribute должна быть допустимой зоной.',
    'unique' => ':attribute уже занят.',
    'uploaded' => ':attribute не удалось загрузить.',
    'url' => ':attribute формат является недействительным.',
    'uuid' => ':attribute должен быть допустимым UUID.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [],

];
