<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

use Illuminate\Pagination\Paginator;
use App\Models\Menu\Menu;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Paginator::useBootstrap();

        \Schema::defaultStringLength(191);

        view()->composer('*', function ($view) {

            if(\Request::route())
            {
                /*Current Route Name.*/
                $current_route_name = \Request::route()->getName();

                if(!strstr($current_route_name,"admin")) {}

                /*Just in User panel*/
                $currentUser = null;
                if(strstr($current_route_name,"user")) {
                    $currentUser = \Auth::guard('web')->user();
                }

                $view->with([
                    'current_route_name'=> $current_route_name,
                    'currentUser' => $currentUser
                ]);
            }
        });

        View::composer('Front.Partials.header', function ($view) {
            $menu = Menu::where('position', 'menu-top')->where('status', true)->first();
            $view->with([
                'menu' => $menu
            ]);
        });

        View::composer('Front.Partials.footer', function ($view) {
            $menuFooterOne = Menu::where('position', 'footer-one')->where('status', true)->first();
            $menuFooterTwo = Menu::where('position', 'footer-two')->where('status', true)->first();
            $menuFooterThree = Menu::where('position', 'footer-three')->where('status', true)->first();
            $menuFooterFour = Menu::where('position', 'footer-four')->where('status', true)->first();
            $view->with([
                'menuFooterOne' => $menuFooterOne,
                'menuFooterTwo' => $menuFooterTwo,
                'menuFooterThree' => $menuFooterThree,
                'menuFooterFour' => $menuFooterFour
            ]);
        });
    }
}
