<?php

namespace App\Models\Menu;

use Illuminate\Database\Eloquent\Model;

class Item extends Model
{
    protected $table = "menu_items";
    protected $fillable = [
        'menu_id',
        'sort_order',
        'title',
        'link',
        'parent_id',
        'status'
    ];

    public function menu()
    {
        return $this->belongsTo('App\Models\Menu\Menu', 'menu_id', 'id');
    }

    public function parent()
    {
        return $this->belongsTo('App\Models\Menu\Item', 'parent_id', 'id');
    }
    public function children()
    {
        return $this->hasMany('App\Models\Menu\Item', 'parent_id', 'id');
    }
}
