<?php

namespace App\Models\Blog;

use Illuminate\Database\Eloquent\Model;

class ArticleCategory extends Model
{
    protected $table = 'article_categories';
    protected $fillable = [
        'sort_order',
        'title',
        'slug',
        'status'
    ];

    public function articles()
    {
        return $this->hasMany('App\Models\Blog\Article', 'article_category_id', 'id');
    }

    public function path()
    {
        return route('front.blog.category', ['category_slug'=>$this->slug ?? ' ']);
    }
}
