<?php

namespace App\Models\Blog;

use Illuminate\Database\Eloquent\Model;

class Article extends Model
{
    protected $table = 'articles';
    protected $fillable = [
        'article_category_id',
        'title',
        'slug',
        'image',
        'header_image',
        'short_text',
        'text',
        'status'
    ];

    public function category()
    {
        return $this->belongsTo('App\Models\Blog\ArticleCategory', 'article_category_id', 'id');
    }

    public function path()
    {
        return route('front.blog.article', ['category_slug'=>$this->category->slug ?? ' ', 'article_slug'=>$this->slug ?? ' ']);
    }
}
