<?php

namespace App\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;

class Admin extends Model implements AuthenticatableContract
{
    use Authenticatable;
    protected $table = "admins";
    protected $fillable = [
        'email',
        'mobile_number',
        'password',
        'is_delete'
    ];

    public function access()
    {
        return $this->belongsToMany("App\Models\AdminAccessItem", "admin_admin_access_items", "admin_id", "admin_access_item_id");
    }
}
