<?php

namespace App\Http\Middleware;

use Closure;

class VerifiedLoginCode
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(!\Auth::guard('web')->check()){
            return redirect()->route('user.auth.login');
        }
        if(!\Auth::guard('web')->user()->login_confirmation_code_verified){
            return redirect()->route('user.auth.login');
        }
        return $next($request);
    }
}
