<?php

namespace App\Http\Middleware;

use Closure;

class AdminHasPermission
{
    public function handle($request, Closure $next, $permission_name)
    {
        if(!\Auth::guard('admin')->check()){
            return redirect()->route('admin.login');
        }

        $admin = \Auth::guard('admin')->user();
        $admin = \App\Models\Admin::findOrFail($admin->id);

        if($admin->id == 1){
            //age admine asli boodesh, dastresi be hame ja azad bashe
            return $next($request);
        }

        $admin_have_permission_names = array();
        if(!empty($admin->access)){
            foreach ($admin->access as $access) {
                $admin_have_permission_names[] = $access->permission_name;
            }
        }
        if(!in_array($permission_name, $admin_have_permission_names)){
            \Session::flash('permission_denied', true);
            return redirect()->route('admin.panel');
        }



        return $next($request);
    }
}
