<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class DarkModeController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'VerifiedLoginCode']);
    }

    public function toggle()
    {
        $user = \Auth::guard('web')->user();

        $html = '';

        if($user->use_dark_mode_in_user_panel){
            $user->update([
                'use_dark_mode_in_user_panel' => false
            ]);
            $html .= '<i class="fa fa-moon" style="font-size: 30px;"></i>';
            $action = 'goToLightMode';
        }
        else{
            $user->update([
                'use_dark_mode_in_user_panel' => true
            ]);
            $html .= '<i class="fa fa-sun" style="font-size: 30px;"></i>' ;
            $action = 'goToDarkMode';
        }

        $array = [
            'html' => $html,
            'action' => $action
        ];

        return response($array);
    }
}
