<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Auth\Events\Registered;

class RegisterController extends Controller
{
    use RegistersUsers;

    protected $redirectTo = '/';

    public function showRegistrationForm()
    {
        if(\Auth::guard('web')->check()){
            if(!empty(\Auth::guard('web')->user()->login_confirmation_code)){
                if(\Auth::guard('web')->user()->login_confirmation_code_verified){
                    if(!empty(\Auth::guard('web')->user()->password)){
                        return view('User.index');
                    }
                }
            }
        }

        /*
         * Age hichKodum az oon sharayet
         * ro nadasht bere be login.
         * va tooye hamoon safhe login dare
         * sharayete mokhtalef ro check mikone
         */
        return view('Front.Auth.login');
    }

    public function __construct()
    {
        $this->middleware('guest');
    }


    public function register(Request $request)
    {
        $request['confirmation_code'] = MainHelper_createNumberCode(4);

        $this->validator($request->all())->validate();

        event(new Registered($user = $this->create($request->all())));

        $this->guard()->login($user);

        /*Ersal e SMS*/
        if(!empty($request['mobile_number'])){
            /*Send code To mobile_number*/
            /*$mobileNumber = $user->mobile_number;
            $variableString = '{"name":"CODE", "value":"'.$user->login_confirmation_code.'"}';
            $templateId = 102988;
            Message_sendSmsWithTemplate($mobileNumber, $variableString, $templateId);*/
        }

        /*return $this->registered($request, $user)
            ?: redirect($this->redirectPath());*/

        $bladeAddress = 'Main.Auth.Partials.confirmCode';
        return $bladeAddress;
    }

    protected function validator(array $data)
    {
        $messages = [];

        return Validator::make($data, [
            'mobile_number' => ['required', 'numeric', 'digits:11', 'regex:/(09)[0-9]{9}/', 'unique:users']
        ],$messages);

    }

    protected function create(array $data)
    {
        $user = User::create([
            'mobile_number' => $data['mobile_number'],
            /*'email' => $data['email'],*/
            /*'password' => Hash::make($data['password']),*/
            'login_confirmation_code' => $data['confirmation_code'],
            'login_confirmation_code_verified' => false
        ]);

        return $user;
    }

    protected function guard()
    {
        return \Auth::guard('web');
    }

    protected function registered(Request $request, $user)
    {
        //
    }
}
