<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use App\PasswordRecovery;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

/*Email*/
use Illuminate\Support\Facades\Mail;
use App\Mail\ConfirmCode;

class PasswordRecoveryController extends Controller
{
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function index()
    {
        return view('Front.Auth.passwordRecovery');
    }

    public function chackDbAndSendSmsEmail(Request $request)
    {
        set_time_limit(0);
        $user = User::where('mobile_number', $request['input'])->first();
        if(empty($user)){
            $users = User::where('auth_document_verify_completed', true)
                ->get();
            foreach($users as $u){
                if($u->authDocument->email == $request['input']){
                    $user = $u;
                }
            }
        }

        if(empty($user)){
            return response('user_not_found', 401);
        }
        else{
            /*Send email and sms*/
            $confirmation_code = create_confirm_code();
            $user->update([
                'login_confirmation_code' => $confirmation_code,
                'login_confirmation_code_verified' => false
            ]);
            /*SMS*/
            $array = [
                $confirmation_code
            ];
            Helper_send_sms($array, $user->mobile_number, 404);

            //Send EMAIL
            if($user->auth_document_verify_completed) {
                $objDemo = new \stdClass();
                $objDemo->code = $user->login_confirmation_code;
                try {
                    Mail::to($user->authDocument->email)->send(new ConfirmCode($objDemo));
                } catch (\Exception $e) {}
            }

            /*Create HTML*/
            $html = '';
            $html .= '<div class="form-group">';
            $html .= '<div class="alert alert-info">';
            $html .= '<strong>توجه:</strong>';
            $html .= '<br/>';
            if($user->auth_document_verify_completed){
                $alert_text = '';
                $alert_text .= 'کد تایید هم به ';
                $alert_text .= $user->mobile_number;
                $alert_text .= ' پیامک شد و هم به ';
                $alert_text .= $user->authDocument->email ?? '';
                $alert_text .= ' ایمیل شد.';
            }
            else{
                $alert_text = '';
                $alert_text .= 'کد تایید به ';
                $alert_text .= $user->mobile_number;
                $alert_text .= ' پیامک شد.';
            }
            $html .= $alert_text;
            $html .= '</div>';
            $html .= '</div>';
            $html .= '<hr/>';
            $route = route('user.passwordRecovery.chackConfirmCode');
            $html .= '<form action="'.$route.'" method="post" id="frm-chackConfirmCode">';
            $html .= csrf_field();
            $html .= '<input type="hidden" name="u_id" value="'.$user->id.'">';
            $html .= '<div class="form-group div-input">';
            $html .= '<label class="control-label">';
            $html .= 'کد تایید را وارد کنید';
            $html .= '</label>';
            $html .= '<input type="text" class="form-control" name="input" placeholder="کد تایید">';
            $html .= '</div>';
            $html .= '<div class="form-group">';
            $html .= '<button type="submit" class="btn btn-search">';
            $html .= 'بررسی کد';
            $html .= '</button>';
            $html .= '</div>';
            $html .= '</form>';

            return response($html);
        }
    }

    public function chackConfirmCode(Request $request)
    {
        $this->validate($request, [
            'u_id' => 'required',
            'input' => 'required'
        ]);

        $user = User::findOrFail($request['u_id']);
        if($user->login_confirmation_code != $request['input']){
            return response('Wrong_code', 401);
        }
        else{
            /*Update USER*/
            $user->update([
                'login_confirmation_code' => null,
                'login_confirmation_code_verified' => true
            ]);
            /*Create html*/
            $html = '';
            $html .= '<div class="form-group">';
            $html .= '<div class="alert alert-info">';
            $html .= '<strong>توجه:</strong>';
            $html .= '<br/>';
            $alert_text = '';
            $alert_text .= 'میتوانید رمز جدید برای حساب کاربری خود تعیین کنید ';
            $html .= $alert_text;
            $html .= '</div>';
            $html .= '</div>';
            $html .= '<hr/>';
            $route = route('user.passwordRecovery.changePassword');
            $html .= '<form action="'.$route.'" method="post" id="frm-changePassword">';
            $html .= csrf_field();
            $html .= '<input type="hidden" name="u_id" value="'.$user->id.'">';
            $html .= '<div class="form-group div-input">';
            $html .= '<label class="control-label">';
            $html .= 'رمز عبور';
            $html .= '</label>';
            $html .= '<input type="password" class="form-control" name="password" placeholder="رمز جدید">';
            $html .= '<label class="err_labels" id="password_err"></label>';
            $html .= '</div>';

            $html .= '<div class="form-group div-input">';
            $html .= '<label class="control-label">';
            $html .= 'تکرار رمز جدید';
            $html .= '</label>';
            $html .= '<input type="password" class="form-control" name="password_confirmation" placeholder="تکرار رمز جدید">';
            $html .= '<label class="err_labels" id="password_confirmation_err"></label>';
            $html .= '</div>';

            $html .= '<div class="form-group">';
            $html .= '<button type="submit" class="btn btn-search">';
            $html .= 'تغییر رمز عبور';
            $html .= '</button>';
            $html .= '</div>';
            $html .= '</form>';

            return response($html);
        }
    }

    public function changePassword(Request $request)
    {
        $this->validate($request, [
            'password' => 'required|min:6|confirmed',
            'password_confirmation' => 'required',
        ],[
            'password.required' => 'رمز عبور جدید را وارد کنید',
            'password.min' => 'حداقل 6 کاراکتر وارد کنید',
            'password.confirmed' => 'رمز با تاییدیه مغایرت دارد',
            'password_confirmation.required' => 'این فیلد را خالی رها نکنید',
        ]);

        $user = User::findOrFail($request['u_id']);
        if($user->login_confirmation_code_verified == false){
            abort(404);
        }
        /*Update USER*/
        $user->update([
            'login_confirmation_code' => null,
            'login_confirmation_code_verified' => false,
            'password' => Hash::make($request['password']),
        ]);

        return response('Done!');
    }
}
