<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Mail\UserSuccessLogin;
use Illuminate\Support\Facades\Mail;

/*Google Authenticator*/
use PragmaRX\Google2FALaravel\Support\Authenticator;

class LoginSmsCodeController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth']);
    }

    /*Show page of sms*/
    public function index()
    {
        //Get Current USER
        $user = \Auth::guard('web')->user();
        // Initialise the 2FA class
        /*$google2fa = app('pragmarx.google2fa');*/
        // Generate the QR image. This is the image the user will scan with their app to set up two factor authentication
        /*$QR_Image = $google2fa->getQRCodeInline(
            config('app.name'),
            $user->mobile_number,//Or Email
            $user->google2fa_secret
        );*/
        //Secret Variable (Maybe not needed!)
        /*$secret = $user->google2fa_secret;*/

        return view('Front.Auth.sms'/*, compact(
            // 'QR_Image'
            //,'secret'
        )*/);
    }

    /*Check and Confirm Code*/
    public function confrim(Request $request)
    {
        $this->validate($request, [
            'code_tayid' => 'required|numeric'
        ]);

        $user = \Auth::guard('web')->user();

        if($request['code_tayid'] == $user->login_confirmation_code){
            $user->update([
                'login_confirmation_code_verified' => true,
            ]);

            /*Send Email*/
            $ip = \Request()->ip();
            $login_data = convert_to_jalali(\Carbon\Carbon::now()->toDateString());
            $login_time = \Carbon\Carbon::now()->setTimeZone("Asia/Tehran")->toTimeString();
            $date_time = $login_data .' - '. $login_time;
            $device = find_user_browser();
            $device_details = $device['browser_name'].' - '.$device['version'].' - '.$device['platform'];

            $objDemo = new \stdClass();
            $objDemo->ip = $ip;
            $objDemo->sender = 'Plutex';
            $objDemo->date_time = $date_time;
            $objDemo->device_details = $device_details;
            $objDemo->status = 'ورود موفق';

            try {
                Mail::to($user->authDocument->email)->send(new UserSuccessLogin($objDemo));
            }
            catch(\Exception $e){}

            return response("DONE");
        }
        else{
            return response()->json('WrongCode', 401);
        }
    }

    /*Check code by GoogleAuthenticator*/
    public function confrim_GoogleAuthenticator(Request $request)
    {
        $this->validate($request, [
            'one_time_password' => 'required|numeric'
        ]);
        $request['one_time_password'] = EnglishNum($request['one_time_password']);

        $authenticator = app(Authenticator::class)->boot($request);

        if (!$authenticator->isAuthenticated()) {
            return response()->json('WrongCode', 401);
        }
        else{

            $user = \Auth::guard('web')->user();
            $user->update([
                'login_confirmation_code_verified' => true,
            ]);

            return response("DONE");
        }
    }
}




