<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Auth\Events\Registered;
use Illuminate\Validation\ValidationException;


class LoginController extends Controller
{
    use AuthenticatesUsers;

    protected $redirectTo = '/';

    public function __construct()
    {
        $this->middleware('guest')->except(['logout', 'showLoginForm']);
    }

    public function showLoginForm()
    {
        try{
            \Session::put('lastUrlBeforeLoginOrRegister', url()->previous());
        }
        catch(\Exception $e){}


        if(\Auth::guard('web')->check()){
            if(!empty(\Auth::guard('web')->user()->login_confirmation_code)){
                if(\Auth::guard('web')->user()->login_confirmation_code_verified){
                    if(!empty(\Auth::guard('web')->user()->password)){
                        return view('User.index');
                    }
                }
            }
        }

        /*
         * Age hichKodum az oon sharayet
         * ro nadasht bere be login.
         * va tooye hamoon safhe login dare
         * sharayete mokhtalef ro check mikone
         */
        return view('Front.Auth.login');
    }

    public function login(Request $request)
    {
        $this->validateLogin($request);

        if (method_exists($this, 'hasTooManyLoginAttempts') &&
            $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if ($this->attemptLogin($request)) {

            return $this->sendLoginResponse($request);
        }

        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

    protected function validateLogin(Request $request)
    {
        $messages = [
            'password.required' => 'رمز عبور را وارد کنید',
            'password.max' => 'کمتر از 191 کاراکتر وارد کنید',
        ];

        $request->validate([
            /*$this->username() => 'required|numeric|digits:11|regex:/(09)[0-9]{9}/',*/
            'password' => 'required|max:191|string',
        ],$messages);

    }

    protected function attemptLogin(Request $request)
    {
        return $this->guard()->attempt(
            $this->credentials($request), $request->filled('remember')
        );
    }

    protected function credentials(Request $request)
    {
        return $request->only($request->user_name ?? 'mobile_number', 'password');
    }

    protected function sendLoginResponse(Request $request)
    {
        $request->session()->regenerate();

        $this->clearLoginAttempts($request);

        return $this->authenticated($request, $this->guard()->user())
            ?: redirect()->intended($this->redirectPath());
    }

    protected function authenticated(Request $request, $user)
    {
        //
    }


    protected function sendFailedLoginResponse(Request $request)
    {
        throw ValidationException::withMessages([
            $this->username() => [trans('auth.failed')],
        ]);
    }


    public function username()
    {
        return 'mobile_number';
    }

    public function logout(Request $request)
    {
        //$this->guard()->logout();
        $this->guard('web')->logout();

        $request->session()->invalidate();

        return $this->loggedOut($request) ?: redirect('/');
    }

    protected function loggedOut(Request $request)
    {
        //
    }

    protected function guard()
    {
        return \Auth::guard('web');
    }
}



