<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Hash;

class CustomedAuthInModalController extends Controller
{
    /**
     * Function vase ersal-e code tayid
    */
    public function fnctn_codeStuff($user_id, $createCodeOrNot)
    {
        $user = User::findOrFail($user_id);
        if( $createCodeOrNot == true ){
            $code = MainHelper_createNumberCode(6);
    
            $user->update([
                'login_confirmation_code' => $code,
                'login_confirmation_code_verified' => false
            ]);
        }

        /*Send code TO mobile_number*/
        /*$mobileNumber = $user->mobile_number;
        $variableString = '{"name":"CODE", "value":"'.$code.'"}';
        $templateId = 102988;
        Message_sendSmsWithTemplate($mobileNumber, $variableString, $templateId);*/

        return 'done';
    }
    
    
    /*
     * Aval check kone ke in mobile
     * vase kasi hastesh ke login karde ya register
     */
    public function check(Request $request)
    {
        $validateErrorMessages = [
            'mobile.required' => 'تلفن همراه خود را وارد کنید',
            'mobile.numeric' => 'در زمان وارد کردن تلفن همراه فقط عدد وارد کنید',
            'mobile.digits' => 'تلفن همراه باید 11 کاراکتر باشد',
        ];
        $this->validate($request, [
            'mobile' => 'required',
        ], $validateErrorMessages);

        /*Persian number convert to english number*/
        $mobile = EnglishNum('0'.$request['mobile']);

        $user = User::where('mobile_number', $mobile)->first();

        $userFound = !empty($user) ? true : false;

        if($userFound){
            /*Login*/
            $route = route('user.auth.modal.loginWithPassword');
            $html = '<form action="'.$route.'" method="post" show-modal="true" class="auth-form" data-scrollable="" data-v-54b431dc="" id="frm-loginWithPass">';
            // $html .= @csrf;
            $html .= '<input type="hidden" name="_token" value="'.csrf_token().'">';
            $html .= '<h3> ورود با رمز عبور</h3>';
            $html .= '<h4> برای ادامه رمز عبور خود را وارد کنید. </h4>';
            
            $html .= '<div class="a-input mb-5 md:mb-6 text-right has-append is-lg">';
            $html .= '<span class="a-input__input">';
            $html .= '<input id="mobail" dir="ltr" readonly root-class="text-right" type="tel" maxlength="10" name="mobile" value="'.$request['mobile'].'">';
            $html .= '<span dir="ltr" class="text-grays-300 mr-1 px-2 border-r">+۹۸</span>';
            $html .= '</span>';
            $html .= '<fieldset></fieldset>';
            $html .= '<label for="mobail" class="a-input__label" disable-dropdown-close="false">شماره موبایل</label>';
            $html .= '</div>';
            
            $html .= '<div class="a-input mb-5 md:mb-6 text-right has-append is-lg">';
            $html .= '<span class="a-input__input">';
            $html .= '<input id="password" dir="ltr" root-class="text-right" type="password" name="password" required>';
            $html .= '</span>';
            $html .= '<fieldset></fieldset>';
            $html .= '<label for="mobail" class="a-input__label" disable-dropdown-close="false">رمز عبور</label>';
            $html .= '</div>';
            
            $html .= '<div class="text-center auth-actions mt-3">';
            
            $html .= '<div class="d-block">';
            $html .= '<button type="submit" class="btn btn-primary  mb-4 form-control">';
            $html .= 'ورود';
            $html .= '</button>';
            $html .= '</div>';
            
            $html .= '<div class="d-block">';
            $sendConfirmCodeRoute = route('user.auth.modal.sendConfirmCode', ['user_id'=>$user->id]);
            $html .= '<a href="'.$sendConfirmCodeRoute.'" class="btn is-md is-link btn-sendConfirmCode">';
            $html .= 'ورود با کد تایید';
            $html .= '</a>';
            $html .= '</div>';
            
            $html .= '</div>';//text-center auth-actions mt-3
            
            $html .= '</form>';
            
            return response($html);
        }
        else{
            /*Register*/
            //Create USER
            $user = User::create([
                'user_type_id' => 1,
                'mobile_number' => $mobile,
                'password' => null,
                'login_confirmation_code' => null,
                'login_confirmation_code_verified' => false,
            ]);
            
            //Send Code
            $this->fnctn_codeStuff($user->id, true);
            
            //Register form
            $route = route('user.auth.modal.checkCodeForRegister', ['user_id'=>$user->id]);
            $html = '<form action="'.$route.'" method="post" show-modal="true" class="auth-form" data-scrollable="" data-v-54b431dc="" id="frm-checkCodeForRegister">';
            $html .= '<input type="hidden" name="_token" value="'.csrf_token().'">';
            $html .= '<input type="hidden" name="user_id" value="'.$user->id.'">';
            $html .= '<h3>تایید تلفن همراه</h3>';
            $html .= '<h4> کد تایید ارسال شده را وارد کنید </h4>';
            
            //Remove this
            $html .= '<h4 style="background: indianred;color: floralwhite;padding: 20px;border-radius: 7px;margin-top: 20px;border-top: 3px solid black;">';
            $html .= 'چون فعلا در مرحله تستی هستیم و به پنل پیامکی دسترسی ندارید کد را اینجا نمایش میدهیم:';
            $html .= '<br/>';
            $html .= 'کد تایید:';
            $html .= User::find($user->id)->login_confirmation_code ?? '';
            $html .= '</h4>';
            
            $html .= '<div class="a-input mb-5 md:mb-6 text-right has-append is-lg">';
            $html .= '<span class="a-input__input">';
            $html .= '<input id="code" dir="ltr" root-class="text-right" type="number" name="code" required>';
            $html .= '</span>';
            $html .= '<fieldset></fieldset>';
            $html .= '<label for="code" class="a-input__label" disable-dropdown-close="false">کد تایید</label>';
            $html .= '</div>';
            
            $html .= '<div class="text-center auth-actions mt-3">';
            
            $html .= '<div class="d-block">';
            $html .= '<button type="submit" class="btn btn-primary  mb-4 form-control">';
            $html .= 'بررسی کد';
            $html .= '</button>';
            $html .= '</div>';
            
            $html .= '</div>';//text-center auth-actions mt-3
            
            $html .= '</form>';
            
            return response($html);
        }
    }
    
    /**
     * ba Password login kone
    */
    public function loginWithPassword(Request $request)
    {
        $this->validate($request, [
            'mobile' => 'required',
            'password' => 'required'
        ],[
            'mobile.required' => 'تلفن همراه خود را وارد کنید',
            'mobile.numeric' => 'در زمان وارد کردن تلفن همراه فقط عدد وارد کنید',
            'mobile.digits' => 'تلفن همراه باید 11 کاراکتر باشد',
            'password.required' => 'رمز عبور را وارد کنید'
        ]);

        /*Persian number convert to english number*/
        $mobile = EnglishNum('0'.$request['mobile']);
        $user = User::where('mobile_number', $mobile)
            ->first();
        $passwordIsTrue = false;
        if( !empty($user) ){
            if( \Hash::check($request['password'], $user->password) ){
                $passwordIsTrue = true;
            }
        }
        
        if( $passwordIsTrue ){
            //Login kon
            \Auth::guard('web')->loginUsingId($user->id);
            return response('DONE!');
        }
        else{
            return response()->json('password_is_wrong', 401);
        }
    }
    
    
    /**
     * Ersale code tayid baraye USER (LOGIN)
    */
    public function sendConfirmCode($user_id)
    {
        $this->fnctn_codeStuff($user_id, true);//Code ham sakhte she va ham ersal she
        
        //Create HTML FORM
        /*Login*/
        $route = route('user.auth.modal.loginWithCode');
        $html = '<form action="'.$route.'" method="post" show-modal="true" class="auth-form" data-scrollable="" data-v-54b431dc="" id="frm-loginWithCode">';
        $html .= '<input type="hidden" name="_token" value="'.csrf_token().'">';
        $html .= '<input type="hidden" name="user_id" value="'.$user_id.'">';
        $html .= '<h3> ورود با کد تایید</h3>';
        $html .= '<h4> کد تایید ارسال شده را وارد کنید </h4>';
        
        //Remove this
        $html .= '<h4 style="background: indianred;color: floralwhite;padding: 20px;border-radius: 7px;margin-top: 20px;border-top: 3px solid black;">';
        $html .= 'چون فعلا در مرحله تستی هستیم و به پنل پیامکی دسترسی ندارید کد را اینجا نمایش میدهیم:';
        $html .= '<br/>';
        $html .= 'کد تایید:';
        $html .= User::find($user_id)->login_confirmation_code ?? '';
        $html .= '</h4>';
        
        $html .= '<div class="a-input mb-5 md:mb-6 text-right has-append is-lg">';
        $html .= '<span class="a-input__input">';
        $html .= '<input id="code" dir="ltr" root-class="text-right" type="number" name="code" required>';
        $html .= '</span>';
        $html .= '<fieldset></fieldset>';
        $html .= '<label for="code" class="a-input__label" disable-dropdown-close="false">کد تایید</label>';
        $html .= '</div>';
        
        $html .= '<div class="text-center auth-actions mt-3">';
        
        $html .= '<div class="d-block">';
        $html .= '<button type="submit" class="btn btn-primary  mb-4 form-control">';
        $html .= 'ورود';
        $html .= '</button>';
        $html .= '</div>';
        
        $html .= '</div>';//text-center auth-actions mt-3
        
        $html .= '</form>';
        
        return response($html);
    }
    
    
    /**
     * Vorud ba code tayid
    */
    public function loginWithCode(Request $request)
    {
        $this->validate($request, [
            'user_id' => 'required',
            'code' => 'required'
        ],[
            'code.required' => 'کد تایید را وارد کنید'
        ]);
        
        $user = User::findOrFail($request['user_id']);
        if( $user->login_confirmation_code == $request['code'] ){
            //Login kon
            \Auth::guard('web')->loginUsingId($user->id);
            
            //Code tayid ro ok karde
            $user->update([
                'login_confirmation_code_verified' => true
            ]);
            
            return response('DONE!');
        }
        else{
            return response()->json('code_is_wrong', 401);
        }
    }
    
    
    
    /**
     * Code tayid ro check kone (Register)
    */
    public function checkCodeForRegister(Request $request)
    {
        $this->validate($request, [
            'user_id' => 'required',
            'code' => 'required'
        ],[
            'code.required' => 'کد تایید را وارد کنید'
        ]);
        
        $user = User::findOrFail($request['user_id']);
        if( $user->login_confirmation_code == $request['code'] ){
            //Login kon
            \Auth::guard('web')->loginUsingId($user->id);
            
            //Code tayid ro ok karde
            $user->update([
                'login_confirmation_code_verified' => true
            ]);
            
            //Form vase store kardan-e password
            $route = route('user.auth.modal.storePassword');
            $html = '<form action="'.$route.'" method="post" show-modal="true" class="auth-form" data-scrollable="" data-v-54b431dc="" id="frm-storePassword">';
            $html .= '<input type="hidden" name="_token" value="'.csrf_token().'">';
            $html .= '<h3>تعیین رمز عبور</h3>';
            $html .= '<h4> رمز عبور برای خودتان تعیین کنید </h4>';
            
            $html .= '<div class="a-input mb-5 md:mb-6 text-right has-append is-lg">';
            $html .= '<span class="a-input__input">';
            $html .= '<input id="password" dir="ltr" root-class="text-right" type="password" name="password" required>';
            $html .= '</span>';
            $html .= '<fieldset></fieldset>';
            $html .= '<label for="password" class="a-input__label" disable-dropdown-close="false">رمز عبور</label>';
            $html .= '</div>';
            
            $html .= '<div class="a-input mb-5 md:mb-6 text-right has-append is-lg">';
            $html .= '<span class="a-input__input">';
            $html .= '<input id="password_confirmation" dir="ltr" root-class="text-right" type="password" name="password_confirmation" required>';
            $html .= '</span>';
            $html .= '<fieldset></fieldset>';
            $html .= '<label for="password_confirmation" class="a-input__label" disable-dropdown-close="false">تایید رمز عبور</label>';
            $html .= '</div>';
            
            $html .= '<div class="text-center auth-actions mt-3">';
            
            $html .= '<div class="d-block">';
            $html .= '<button type="submit" class="btn btn-primary  mb-4 form-control">';
            $html .= 'ثبت رمز';
            $html .= '</button>';
            $html .= '</div>';
            
            $html .= '</div>';//text-center auth-actions mt-3
            
            $html .= '</form>';
            
            return response($html);
        }
        else{
            return response()->json('code_is_wrong', 401);
        }
    }
    
    
    /**
     * Store password for user
    */
    public function storePassword(Request $request)
    {
        $this->validate($request, [
            'password' => 'required|confirmed',
            'password_confirmation' => 'required',
        ],[
            'password.required' => 'رمز عبور را وارد کنید',
            'password.confirmed' => 'رمز عبور با تاییدیه متفاوت می باشد',
            'password_confirmation.required' => 'تاییدیه رمز عبور را وارد کنید'
        ]);
        
        $user = \Auth::guard('web')->user();
        $user->update([
            'password' => Hash::make($request['password'])
        ]);
        
        return response('DONE!');
    }
    
}




