<?php

namespace App\Http\Controllers\User\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Hash;

class CustomedAuthController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except(['check', 'sendCodeForLoginWithCode', 'loginWithCodeTayid']);
    }

    /*
     * Aval check kone ke in mobile
     * vase kasi hastesh ke login karde ya register
     */
    public function check(Request $request)
    {
        $request['captcha'] = $request['g-recaptcha-response'];
        $validateErrorMessages = [
            'mobile_or_email.required' => 'تلفن همراه خود را وارد کنید',
            'mobile_or_email.regex' => 'شماره موبال خود را به صورت 09XXXXXXXXX وارد کنید',
            'mobile_or_email.numeric' => 'در زمان وارد کردن تلفن همراه فقط عدد وارد کنید',
            'mobile_or_email.digits' => 'تلفن همراه باید 11 کاراکتر باشد',
            'mobile_or_email.email' => 'فرمت ایمیل وارد شده اشتباه می باشد',
            'mobile_or_email.max' => 'کمتر از 191 کاراکتر وارد کنید',
            'captcha.required' => 'لطفا تعیین کنید که ربات نیستید',
        ];
        $this->validate($request, [
            'mobile_or_email' => 'required',
            'captcha' => 'required'
        ], $validateErrorMessages);

        /*Persian number convert to english number*/
        $request['mobile_or_email'] = EnglishNum($request['mobile_or_email']);

        /*Check kone ke mobile vared shode ya email*/
        if(is_numeric($request['mobile_or_email'])){
            /*MOBILE*/
            $this->validate($request, [
                'mobile_or_email' => 'numeric|digits:11|regex:/(09)[0-9]{9}/',
                'captcha' => 'required'
            ], $validateErrorMessages);

            $user = User::where('mobile_number', $request['mobile_or_email'])->first();

            $request['mobile_number'] = $request['mobile_or_email'];
            $request['email'] = null;
        }
        else{
            /*EMAIL*/
            $this->validate($request, [
                'mobile_or_email' => 'email|max:191',
                'captcha' => 'required'
            ], $validateErrorMessages);

            $user = User::where('email', $request['mobile_or_email'])->first();

            $request['mobile_number'] = null;
            $request['email'] = $request['mobile_or_email'];
        }

        $userFound = !empty($user) ? true : false;

        if($userFound){
            /*Login*/
            return view('Front.Auth.Partials.getPassword', compact(
                'user'
            ))->with(['type'=>'login']);
        }
        else{
            /*Register*/
            $bladeAddress = app('App\Http\Controllers\User\Auth\RegisterController')->register($request);
            return view($bladeAddress)->with(['type'=>'register']);
        }
    }

    /*
     * Ersal e mojadade CODE
     */
    public function resendCode()
    {
        /*Send code TO mobile_number*/
        /*$user = \Auth::guard('web')->user();
        $mobileNumber = $user->mobile_number;
        $variableString = '{"name":"CODE", "value":"'.$user->login_confirmation_code.'"}';
        $templateId = 102988;
        Message_sendSmsWithTemplate($mobileNumber, $variableString, $templateId);*/
    }

    /*Code tayid mishe ya na*/
    public function checkConfirmCode(Request $request)
    {
        $this->validate($request, [
            'code' => 'required'
        ],[
            'code.required' => 'کد تایید را وارد کنید'
        ]);

        if($request['code'] == \Auth::guard('web')->user()->login_confirmation_code){
            $user = \Auth::guard('web')->user();
            $user->update([
                'login_confirmation_code_verified' => true
            ]);

            if(empty($user->password)){//Hanuz ramz entekhab nashode
                return view('Front.Auth.Partials.setPassword');
            }
            else{//Pas ghablan ramz entekhab shode
                $array = [
                    'whatToDo' => 'goToUrl',
                    'html' => '',
                    'url' => route('user.profile')
                ];
                return response($array);
            }
        }
        else{
            return response()->json('code_is_incorrect', 401);
        }
    }

    /*
     * Tayin e ramz baraye user
     */
    public function setPassword(Request $request)
    {
        $this->validate($request, [
            'password' => 'required|min:6|confirmed'
        ],[
            'password.required' => 'رمز عبور را وارد کنید',
            'password.min' => 'رمز عبور باید بیش از 6 کاراکتر باشد',
            'password.confirmed' => 'رمز عبور با تاییدیه مطابقت ندارد'
        ]);

        $user = \Auth::guard('web')->user();
        $user->update([
            'password' => Hash::make($request['password'])
        ]);

        return response('Registering operation is complete!');
    }

    /*
     * Ersale code tayid
     * va raftan be safhe code tayid
     * vase inke ba code tayid LOGIN kone
     */
    public function sendCodeForLoginWithCode($user_id)
    {
        $user = User::findOrFail($user_id);

        $code = MainHelper_createNumberCode(4);

        $user->update([
            'login_confirmation_code' => $code,
            'login_confirmation_code_verified' => false
        ]);

        /*Send code TO mobile_number*/
        /*$mobileNumber = $user->mobile_number;
        $variableString = '{"name":"CODE", "value":"'.$code.'"}';
        $templateId = 102988;
        Message_sendSmsWithTemplate($mobileNumber, $variableString, $templateId);*/

        return view('Front.Auth.Partials.loginWithCode', compact(
            'user'
        ));
    }

    /*
     * ba code tayid login kone
     */
    public function loginWithCodeTayid(Request $request, $user_id)
    {
        $this->validate($request, [
            'code' => 'required'
        ],[
            'code.required' => 'کد تایید را وارد کنید'
        ]);

        $user = User::findOrFail($user_id);
        if($request['code'] == $user->login_confirmation_code){
            $user->update([
                'login_confirmation_code_verified' => true
            ]);

            /*Login kone ba hamoon id*/
            \Auth::guard('web')->loginUsingId($user_id);
            return response('DONE!');
        }
        else{
            return response()->json('code_is_incorrect', 401);
        }
    }
}




