<?php

namespace App\Http\Controllers\Front\Page;

use App\Http\Controllers\Controller;
use App\Models\Page\Page;
use Illuminate\Http\Request;

class PageController extends Controller
{
    public function show($slug)
    {
        $page = Page::where('slug', $slug)
            ->where('status', true)
            ->firstOrFail();

        if(!\Auth::guard('admin')->check()) {
            $page->update([
                'visit_count' => $page->visit_count + 1
            ]);
        }

        return view('Front.Page.show', compact(
            'page'
        ));
    }
}
