<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Slideshow\Slideshow;
use App\Models\Blog\Article;
use App\Models\Faq\Faq;

class HomeController extends Controller
{
    public function __construct(){}

    public function index()
    {
        $slideshows = Slideshow::where('status', true)
            ->orderBy('sort_order', 'asc')
            ->get();

        $firstPageChallenge = \App\Models\FirstPageChallenge\Desc::where('status', true)
            ->first();
        $firstPageChallengeItems = \App\Models\FirstPageChallenge\Item::where('status', true)
            ->orderBy('sort_order', 'asc')
            ->get();

        $firstPageBestChallenge = \App\Models\FirstPageBestChallenge\Desc::where('status', true)
            ->first();
        $firstPageBestChallengeItems = \App\Models\FirstPageBestChallenge\Item::where('status', true)
            ->orderBy('sort_order', 'asc')
            ->get();

        $firstPageGuide =\App\Models\FirstPageGuide\Desc::where('status', true)
            ->first();

        $articles = Article::where('status', true)
            ->latest()
            ->take(5)
            ->get();

        $faqs = Faq::where('status', true)
            ->where('show_in_first_page', true)
            ->orderBy('sort_order', 'asc')
            ->get();

        $firstPageStep = \App\Models\FirstPageStep\Desc::where('status', true)
            ->first();
        $firstPageReceiveCapital_desc = \App\Models\FirstPageReceiveCapital\Desc::where('status', true)
            ->first();
        $firstPageReceiveCapital_items = \App\Models\FirstPageReceiveCapital\Item::where('status', true)
            ->orderBy('sort_order', 'asc')
            ->get();


        return view('Front.index', compact(
            'slideshows',
            'firstPageChallenge', 'firstPageChallengeItems',
            'firstPageBestChallenge', 'firstPageBestChallengeItems',
            'articles',
            'faqs',
            'firstPageStep',
            'firstPageReceiveCapital_desc', 'firstPageReceiveCapital_items',
            'firstPageGuide'
        ));
    }
}




