<?php

namespace App\Http\Controllers\Front\ContactUsPage;

use App\Http\Controllers\Controller;
use App\Models\ContactUsPage\Desc\ContactUsPage;
use App\Models\ContactUsPage\Message\ContactUsMessage;
use Illuminate\Http\Request;

class ContactUsController extends Controller
{
    public function index()
    {
        $contactUs = ContactUsPage::where('whole_page_status', true)
            ->firstOrFail();

        return view('Front.ContactUsPage.index', compact(
            'contactUs'
        ));
    }

    public function sendMessage(Request $request)
    {
        ContactUsMessage::create([
            'name' => $request['name'],
            'email' => $request['email'],
            'message' => $request['message'],
            'seened_by_admin' => false,
        ]);

        return response('done');
    }


}
