<?php

namespace App\Http\Controllers\Front\Blog;

use App\Models\Blog\ArticleCategory;
use App\Models\Blog\Article;
use App\Http\Controllers\Controller;

class BlogController extends Controller
{
    protected $pageLimit = 21;

    public function index()
    {
        $categories = ArticleCategory::where('status', true)
            ->orderBy('sort_order', 'asc')
            ->get();
        $search = request('search');

        $articles = Article::where('status', true)->when($search, function ($query, $search) {
            return $query->where(function ($q) use($search) {
                $q->where('title', 'LIKE', '%'.$search.'%')
                    ->orWhere('text', 'LIKE', '%'.$search.'%');
            });
        })->latest()->paginate($this->pageLimit);
        $featured = $articles->first();
        $articles->forget(0);

        return view('Front.Blog.index', compact(
            'articles',
            'categories',
            'featured'
        ));
    }

    public function show($category_slug, $article_slug)
    {
        $category = ArticleCategory::where('slug', $category_slug)
            ->where('status', true)
            ->firstOrFail();
        $article = Article::where('slug', $article_slug)
            ->where('article_category_id', $category->id)
            ->where('status', true)
            ->firstOrFail();

        $categories = ArticleCategory::where('status', true)
            ->orderBy('sort_order', 'asc')
            ->get();

        return view('Front.Blog.show', compact(
            'article',
            'categories'
        ));
    }

    public function category($category_slug)
    {
        $category = ArticleCategory::where('slug', $category_slug)
            ->where('status', true)
            ->firstOrFail();
        $title = $category->title;

        $categories = $category->activeChildren;
        $search = request('search');
        $articles = Article::where('status', true)
            ->when($search, function ($query, $search) {
                return $query->where(function ($q) use($search) {
                    $q->where('title', 'LIKE', '%'.$search.'%')
                        ->orWhere('description', 'LIKE', '%'.$search.'%');
                });
            })->latest()->paginate($this->pageLimit);
        $featured = $articles->first();
        $articles->forget(0);

        return view('Front.Blog.index', compact(
            'articles',
            'categories',
            'featured',
            'title'
        ));
    }
}
