<?php

namespace App\Http\Controllers\Admin\Slideshow;

use App\Http\Controllers\Controller;
use App\Models\Slideshow\Slideshow;
use Illuminate\Http\Request;

class SlideshowController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:slideshows');
    }

    public function index()
    {
        $items = Slideshow::orderBy('sort_order', 'asc')
            ->get();

        return view('Admin.Slideshow.index', compact(
            'items'
        ));
    }

    public function create()
    {
        return view('Admin.Slideshow.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'sort_order' => 'required|numeric',
            'image_desktop' => 'required|image|mimes:jpg,jpeg,png|max:10000',
            'image_mobile' => 'required|image|mimes:jpg,jpeg,png|max:10000',
            'status' => 'required|numeric|in:0,1'
        ],[
            'sort_order.required' => 'ترتیب نمایش را وارد کنید',
            'sort_order.numeric' => 'فقط عدد وارد کنید',
            'image_desktop.required' => 'تصویر را وارد کنید',
            'image_desktop.image' => 'فایل انتخاب شده پشتیبانی نمیشود',
            'image_desktop.mimes' => 'تصویر انتخاب شده پشتیبانی نمیشود',
            'image_desktop.max' => 'حجم فایل کمتر از 10 مگ باشد',
            'image_mobile.required' => 'تصویر را وارد کنید',
            'image_mobile.image' => 'فایل انتخاب شده پشتیبانی نمیشود',
            'image_mobile.mimes' => 'تصویر انتخاب شده پشتیبانی نمیشود',
            'image_mobile.max' => 'حجم فایل کمتر از 10 مگ باشد',
            'status.required' => 'وضعیت را تعیین کنید'
        ]);

        $imageDesktop = null;
        if(!empty($request['image_desktop'])){
            $sizes = getimagesize($request['image_desktop']);
            $imageDesktop = store_image($request['image_desktop'], 'slideshow', $sizes[0], $sizes[1]);
        }
        $imageMobile = null;
        if(!empty($request['image_mobile'])){
            $sizes1 = getimagesize($request['image_mobile']);
            $imageMobile = store_image($request['image_mobile'], 'slideshow', $sizes1[0], $sizes1[1]);
        }

        Slideshow::create([
            'sort_order' => $request['sort_order'],
            'image_desktop' => $imageDesktop,
            'image_mobile' => $imageMobile,
            'status' => $request['status'],
            'title_one' => $request['title_one'],
            'title_two' => $request['title_two'],
            'title_three' => $request['title_three'],
            'text' => $request['text'],
            'button_status' => $request['button_status'],
            'button_title' => $request['button_title'],
            'button_link' => $request['button_link']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return redirect()->route('admin.slideshow.index');
    }

    public function edit($id)
    {
        $item = Slideshow::findOrFail($id);

        return view('Admin.Slideshow.edit', compact(
            'item'
        ));
    }

    public function update(Request $request, $id)
    {
        $item = Slideshow::findOrFail($id);

        $this->validate($request,[
            'sort_order' => 'required|numeric',
            'image_desktop' => 'nullable|image|mimes:jpg,jpeg,png|max:10000',
            'image_mobile' => 'nullable|image|mimes:jpg,jpeg,png|max:10000',
            'status' => 'required|numeric|in:0,1'
        ],[
            'sort_order.required' => 'ترتیب نمایش را وارد کنید',
            'sort_order.numeric' => 'فقط عدد وارد کنید',
            'image_desktop.image' => 'فایل انتخاب شده پشتیبانی نمیشود',
            'image_desktop.mimes' => 'تصویر انتخاب شده پشتیبانی نمیشود',
            'image_desktop.max' => 'حجم فایل کمتر از 10 مگ باشد',
            'image_mobile.image' => 'فایل انتخاب شده پشتیبانی نمیشود',
            'image_mobile.mimes' => 'تصویر انتخاب شده پشتیبانی نمیشود',
            'image_mobile.max' => 'حجم فایل کمتر از 10 مگ باشد',
            'status.required' => 'وضعیت را تعیین کنید'
        ]);

        $imageDesktop = $item->image_desktop ?? null;
        if(!empty($request['image_desktop'])){
            try{
                unlink($item->image_desktop);
            } catch(\Exception $e){}

            $sizes = getimagesize($request['image_desktop']);
            $imageDesktop = store_image($request['image_desktop'], 'slideshow', $sizes[0], $sizes[1]);
        }
        $imageMobile = $item->image_mobile ?? null;
        if(!empty($request['image_mobile'])){
            try{
                unlink($item->image_mobile);
            } catch(\Exception $e){}
            $sizes1 = getimagesize($request['image_mobile']);
            $imageMobile = store_image($request['image_mobile'], 'slideshow', $sizes1[0], $sizes1[1]);
        }

        $item->update([
            'sort_order' => $request['sort_order'],
            'image_desktop' => $imageDesktop,
            'image_mobile' => $imageMobile,
            'status' => $request['status'],
            'title_one' => $request['title_one'],
            'title_two' => $request['title_two'],
            'title_three' => $request['title_three'],
            'text' => $request['text'],
            'button_status' => $request['button_status'],
            'button_title' => $request['button_title'],
            'button_link' => $request['button_link']
        ]);

        flash_message('success', 'با موفقیت ثبت شد', '');
        return redirect()->route('admin.slideshow.index');
    }

    public function delete($id)
    {
        $item = Slideshow::findOrFail($id);

        try{
            unlink($item->image_desktop);
            unlink($item->image_mobile);
        } catch(\Exception $e){}

        Slideshow::destroy($id);

        flash_message('info', 'حذف شد', '');
        return back();
    }

}




