<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('admin');
        $this->middleware('AdminHasPermission:setting');
    }

    public function index()
    {
        $items = Setting::all();

        return view('Admin.Setting.index', compact(
            'items'
        ));
    }

    public function edit($id)
    {
        $item = Setting::findOrFail($id);

        return view('Admin.Setting.edit', compact(
            'item'
        ));
    }

    public function update(Request $request, $id)
    {
        $item = Setting::findOrFail($id);
        if(!empty($item->rules)) {
            $this->validate($request, [
                'value' => $item->rules
            ]);
        }

        if($item->type == 'text'){
            $value = $request['value'] ?? '';
        }
        if($item->type == 'image'){
            $value = $item->value ?? '';
            if(!empty($request['value'])){
                $file = $request['value'];
                $filename = $file->getClientOriginalName();
                $path = 'images/setting';
                $file->move($path, $filename);
                $value = $path.'/'.$filename;
            }
        }
        if($item->type == 'footerSocialIcons'){
            $array = array();

            $icons_all = array();
            $icons_old = $request['icons_old'];
            if(!empty($icons_old)){
                if(count($icons_old)){
                    foreach($icons_old as $icon_old){
                        $icons_all[] = $icon_old;
                    }
                }
            }
            $icons_new = $request['icons_new'];
            if(!empty($icons_new)){
                if(count($icons_new)){
                    foreach($icons_new as $icon_new){
                        $icons_all[] = $icon_new;
                    }
                }
            }

            $links = $request['links'];

            foreach($icons_all as $key=>$icon){
                if(
                    $links[$key] != '' &&
                    $icon != ''
                ){
                    if( is_string($icon) ){
                        $thisIcon = $icon;
                    }
                    else{
                        $file = $icon;
                        $filename = $file->getClientOriginalName();
                        $path = 'images/setting';
                        $file->move($path, $filename);
                        $thisIcon = $path.'/'.$filename;
                    }

                    $array[] = [
                        'icon' => $thisIcon,
                        'link' => $links[$key]
                    ];
                }
            }

            if(count($array)){
                $value = json_encode($array);
            }
            else{
                $value = null;
            }

        }

        $item->update([
            'value' => $value
        ]);

        flash_message('success', 'باموفقیت ثبت شد', '');
        return back();
    }

}




